<?php get_header(); ?>
<main>

      <!-- banner Carousel -->
      <?php
$banners = new WP_Query([
    'post_type' => 'banner',
    'posts_per_page' => -1,
    'orderby' => 'menu_order',
    'order' => 'ASC'
]);

?>

<?php if ($banners->have_posts()): ?>
<div id="ktidbBannerCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="4000" data-bs-ride="carousel">
    <div class="carousel-inner">
        <?php $i = 0; while ($banners->have_posts()): $banners->the_post(); ?>
            <?php
                $image = get_field('banner_image');
                $subtitle = get_field('subtitle');
                $button_text = get_field('button_text');
                $button_link = get_field('button_link');
            ?>
            <div class="carousel-item <?php echo $i === 0 ? 'active' : ''; ?>">
            <div class="d-block w-100 carousel-h" style="background-image: url('<?php echo esc_url($image); ?>'); background-size: cover; background-position: center; background-repeat: no-repeat;">

                <div class="carousel-caption">
                  <?php if ($subtitle): ?>  <span><?php echo esc_html($subtitle); ?></span> 
                        <h2><?php the_title(); ?></h2>
                       <?php endif; ?>
                              <?php if ($button_text && $button_link): ?>
                            <div >      <a class="btn btn-primary" target="_blank" href="<?php echo esc_url($button_link); ?>"><?php echo esc_html($button_text); ?></a>
                            </div> <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php $i++; endwhile; wp_reset_postdata(); ?>
    </div>

    <!-- Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#ktidbBannerCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#ktidbBannerCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Next</span>
    </button>
</div>
<?php endif; ?>

      <!-- banner Carousel -->

      <!--about Toddy-->
      <div class="flex-container">
      <?php
$about_query = new WP_Query([
    'post_type' => 'about_ktidb',
    'posts_per_page' => 1,
]);

if ($about_query->have_posts()) : 
    while ($about_query->have_posts()) : $about_query->the_post(); ?>
       
        <?php   $about_content = get_field('about_content');
                $about_url = get_field('url_aboutus');  ?>
        <div class="container">
         <!--1-->
         <div class="row">
            <div class="col-12 text-center about-dep">
               <h3><?php the_title(); ?> </h3>
             <!--  <h1>Know more about Toddy Department</h1>-->
          <p> <?php echo $about_content; ?></p> 
            </div> <div class="d-flex justify-content-center mt-3">
                        <a href="<?php echo $about_url; ?>" class="btn tp-btn tp-btn-green">Read More</a>
                    </div>


         </div>
    <?php endwhile;
    wp_reset_postdata();
else : ?>
    <p>No content available for About Us.</p>
<?php endif; ?>



         <!--1-->



         
         <!--2-->
         <div class="row align-items-center justify-content-center">
            <div class="col-md-4">
               <div class="menu1">
                  <a href="<?php echo home_url(); ?>/project" class="cont">
                     <img src="<?php echo get_template_directory_uri(); ?>/assets/img/achievements.svg" width="60" alt=""><br>
                     Projects
                  </a>
               </div>
            </div>
            <div class="col-md-4">
               <div class="menu2">
                  <a href="<?php echo home_url(); ?>/directors" class="cont">
                     <img src="<?php echo get_template_directory_uri(); ?>/assets/img/directorboard.svg" width="60" alt=""><br>
                     Director's Board
                  </a>
               </div>
            </div>
           
         </div>
         <!--2-->
      </div>
      <!--about Toddy-->


      <!--directors details-->
      <div class="directors">
         <div class="container">
          
            <h2>Our Core team</h2>
            <div class="row justify-content-between">
           
   <?php 
$args = array(
    'post_type' => 'director',
    'posts_per_page' => -1,
    'orderby' => 'menu_order',
    'order' => 'DESC'
);
$query = new WP_Query($args);

$allowed_positions = array(
    'Chief Minister, Kerala',
    'Chairman',
    'Minister for Excise & Local Self Government'
);
?>

<?php if ($query->have_posts()): ?>
<section class="directors-section py-5">
    <div class="container">
        <div class="row">
            <?php 
            while ($query->have_posts()) : $query->the_post();
                $name = get_the_title();
                $position = get_field('position');

                if (in_array($position, $allowed_positions)) :
                    $image_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                    if (!$image_url) {
                        $image_url = get_template_directory_uri() . '/assets/img/default.png';
                    }
            ?>
                <div class="col-md-4 mb-4 text-center">
                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($name); ?>" class="img-fluid mb-3">
                    <h4><?php echo esc_html($name); ?></h4>
                    <p><?php echo esc_html($position); ?></p>
                </div>
            <?php 
                endif;
            endwhile;
            wp_reset_postdata();
            ?>
        </div>
    </div>
</section>
<?php endif; ?>

</div></div></div>
           
      <!--directors details-->


      <!--vision/mission news-->
      <div class="container">
         <div class="row news-vision">
            <?php
$page_id = get_page_by_path('about')->ID;
$vision = get_field('vision_statement', $page_id);
$mission = get_field('mission_statement', $page_id);
// Limit to 30 words
$vision_excerpt = wp_trim_words($vision, 43, '...');
$mission_excerpt = wp_trim_words($mission, 39, '...'); ?>
            <!--vision/mission-->
            <div class="col-md-6">
               <div class="vision">
                  <h3>Vision</h3>
                  <p><?php echo $vision_excerpt; ?></p>
               </div>
               <div class="mission">
                  <h3>Mission</h3>
                  <p> <?php echo $mission_excerpt; ?></p>
               </div>
            </div>
            <!--vision/mission-->

            <!--news-->
            <div class="col-md-6">
   <div class="ms-5 news-toddy">
      <h3 class="mb-4">News &amp; Announcements</h3>
      <marquee onmouseover="this.stop();" onmouseout="this.start();" scrollamount="5" direction="up">
         <div style="height: 260px;">
            <?php   
                
            $news_query = new WP_Query([
               'post_type' => 'ktidb_news',
               'posts_per_page' => 10,
               'orderby' => 'date',
               'order' => 'DESC'
            ]);
            if ($news_query->have_posts()) :
               while ($news_query->have_posts()) : $news_query->the_post(); ?> 
            <?php    $news = get_field('news'); ?>
              
               
                  <p><?php echo esc_html($news ?: get_the_title()); ?></p>

               
               <?php endwhile;
               wp_reset_postdata();
            else : ?>
               <p>No news available right now.</p>
            <?php endif; ?>
         </div>
      </marquee>
      <a href="<?php echo get_post_type_archive_link('ktidb_news'); ?>" class="btn btn-outline-primary">View All News</a>

      
   </div>
</div>

            <!--news-->

         </div>
      </div>
      <!--vision/mission news-->


   </main>
<?php get_footer(); ?>