<?php if( ! defined( 'ABSPATH' ) ) exit();

global $product;

$id = $product->get_id();

if ( ! wc_review_ratings_enabled() ) {
	return;
}

$review_count 	= $product->get_review_count();
$rating      	= $product->get_average_rating();
$html 		  	= '';

if ( $rating > 0 ) {
	?>
	<div class="yachbat-product-review">
		<div class="star-rating" role="img" aria-label="<?php echo sprintf( __( 'Rated %s out of 5', 'yachbat' ), $rating ); ?>">
			<span class="rating-percent" style="width: <?php echo esc_attr( ( $rating / 5 ) * 100 ).'%'; ?>;"></span>
			<?php if ( $review_count > 0 ): ?>
				<span class="rating"><?php echo esc_html( $review_count ); ?></span>'
			<?php else: ?>
				<strong class="rating"><?php echo esc_html( $rating ); ?></strong>
			<?php endif; ?>
		</div>
		<?php if ( $review_count > 0 ): ?>
			<span class="parentheses-rating"><?php echo '('.esc_html( $rating ).' '.esc_html__('rating', 'yachbat').')'; ?></span>
		<?php endif; ?>
	</div>
	<?php
}
