<?php

defined( 'ABSPATH' ) || exit;

global $product;
$post_id = get_the_id();

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}

?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<div class="yachbat-single-product">
		<div class="yachbat-before-single-product">
			<?php
			/**
			 * Hook: yachbat_wc_before_single_product.
			 *
			 * @hooked yachbat_wc_template_single_title - 5
			 * @hooked yachbat_wc_template_single_price - 5
			 */
			do_action( 'yachbat_wc_before_single_product' );
			?>
		</div>

		<div class="yachbat-summary">
			<div class="yachbat-summary-left">
				<?php
				/**
				 * Hook: yachbat_wc_single_product_summary_left.
				 *
				 * @hooked yachbat_wc_template_single_image - 10
				 * @hooked yachbat_wc_template_product_description - 10
				 * @hooked yachbat_wc_template_product_features - 15
				 * @hooked yachbat_wc_template_product_policies - 15
				 * @hooked yachbat_wc_template_product_location - 15
				 * @hooked yachbat_wc_template_product_calendar - 20
				 * @hooked yachbat_wc_template_product_tags - 20
				 * @hooked yachbat_wc_template_product_review - 20
				 */
				do_action( 'yachbat_wc_single_product_summary_left' );
				?>
			</div>
			<div class="yachbat-summary-right">
				<?php
				/**
				 * Hook: yachbat_wc_single_product_summary_right.
				 *
				 * @hooked yachbat_wc_template_product_taxonomy - 10
				 * @hooked yachbat_wc_template_product_forms_tab - 10
				 */
				do_action( 'yachbat_wc_single_product_summary_right' );
				?>
			</div>
			
		</div>

		<?php
		/**
		 * Hook: yachbat_wc_after_single_product.
		 *
		 * @hooked yachbat_wc_template_product_related - 20
		 */
		do_action( 'yachbat_wc_after_single_product' );
		?>
	</div>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
