<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Color;
use Elementor\Utils;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Yachbat_Elementor_Testimonial_Carousel extends Widget_Base {

	public function get_name() {
		return 'yachbat_elementor_testimonial_carousel';
	}

	public function get_title() {
		return esc_html__( 'Testimonial Carousel', 'yachbat' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'yachbat' ];
	}

	public function get_script_depends() {
		// Carousel
		wp_enqueue_style( 'owl-carousel', get_template_directory_uri().'/assets/libs/carousel/assets/owl.carousel.min.css' );
		wp_enqueue_script( 'owl-carousel', get_template_directory_uri().'/assets/libs/carousel/owl.carousel.min.js', array('jquery'), false, true );
		return [ 'yachbat-elementor-testimonial-carousel' ];
	}

	protected function register_controls() {


		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
			]
		);

			$this->add_control(
				'version',
				[
					'label' 	=> esc_html__( 'Version', 'yachbat' ),
					'type' 		=> Controls_Manager::SELECT,
					'default' 	=> 'version_1',
					'options' 	=> [
						'version_1' => esc_html__( 'Version 1', 'yachbat' ),
						'version_2' => esc_html__( 'Version 2', 'yachbat' ),
					]
				]
			);

			$repeater = new \Elementor\Repeater();

			
				$repeater->add_control(
					'name_author',
					[
						'label'   => esc_html__( 'Author Name', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
					],
					
					
				);

				$repeater->add_control(
					'job',
					[
						'label'   => esc_html__( 'Job', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXT,

					]
				);

				$repeater->add_control(
					'link',
					[
						'label' 		=> esc_html__( 'Link', 'yachbat' ),
						'type' 			=> \Elementor\Controls_Manager::URL,
						'placeholder' 	=> esc_html__( 'https://your-link.com', 'yachbat' ),
						'default' 		=> [
							'url' 				=> '',
							'is_external' 		=> false,
							'nofollow' 			=> false,
							'custom_attributes' => '',
						],
						'label_block' => true,
					]
				);

				$repeater->add_control(
					'image_author',
					[
						'label'   => esc_html__( 'Author Image', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater->add_control(
					'testimonial',
					[
						'label'   => esc_html__( 'Testimonial ', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXTAREA,
						'default' => esc_html__( '"Sed ullamcorper morbi tincidunt or massa eget egestas purus. Non nisi est sit amet facilisis magna etiam."', 'yachbat' ),
					]
				);

				$this->add_control(
					'tab_item',
					[
						'label'       => esc_html__( 'Items Testimonial', 'yachbat' ),
						'type'        => Controls_Manager::REPEATER,
						'fields'      => $repeater->get_controls(),
						'default' => [
							[
								'name_author' => esc_html__('Sofia brichet', 'yachbat'),
								'job' 		  => esc_html__('Some Company Name', 'yachbat'),
								'testimonial' => esc_html__('There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don"t look even.', 'yachbat'),
							],
							[
								'name_author' => esc_html__('James thomas', 'yachbat'),
								'job' 		  => esc_html__('Some Company Name', 'yachbat'),
								'testimonial' => esc_html__('Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy.', 'yachbat'),
							],
							[
								'name_author' => esc_html__('Peek Thakul', 'yachbat'),
								'job' 		  => esc_html__('Governer Of Canada', 'yachbat'),
								'testimonial' => esc_html__('Tools to network more effectively, including an orientation CD giving the Formula for Success" in BNI, a badge, a vinyl card holder to carry.', 'yachbat'),
							],
						],
						'title_field' => '{{{ name_author }}}',
						'condition'   => [
							'version' 	=> 'version_1',
						],
					]
				);

			//repeater v2
			$repeater2 = new \Elementor\Repeater();

				$repeater2->add_control(
					'icon',
					[
						'label' 	=> __( 'Icon', 'yachbat' ),
						'type' 		=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'icomoon icomoon-comment-2',
							'library'	=> 'solid',
						],
					]
				);

				$this->add_responsive_control(
					'size_icon',
					[
						'label' 		=> esc_html__( 'Size', 'yachbat' ),
						'type' 			=> Controls_Manager::SLIDER,
						'size_units' 	=> [ 'px'],
						'range' 		=> [
							'px' => [
								'min' 	=> 0,
								'max' 	=> 100,
								'step' 	=> 1,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .ova-button .ova-text i' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);
			
				$repeater2->add_control(
					'name_author',
					[
						'label'   => esc_html__( 'Author Name', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
					],
					
					
				);

				$repeater2->add_control(
					'job',
					[
						'label'   => esc_html__( 'Job', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXT,

					]
				);

				$repeater2->add_control(
					'image_author',
					[
						'label'   => esc_html__( 'Author Image', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater2->add_control(
					'link',
					[
						'label' 		=> esc_html__( 'Link', 'yachbat' ),
						'type' 			=> \Elementor\Controls_Manager::URL,
						'placeholder' 	=> esc_html__( 'https://your-link.com', 'yachbat' ),
						'default' 		=> [
							'url' 				=> '',
							'is_external' 		=> false,
							'nofollow' 			=> false,
							'custom_attributes' => '',
						],
						'label_block' => true,
					]
				);

				$repeater2->add_control(
					'testimonial',
					[
						'label'   => esc_html__( 'Testimonial ', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXTAREA,
						'default' => esc_html__( '"Sed ullamcorper morbi tincidunt or massa eget egestas purus. Non nisi est sit amet facilisis magna etiam."', 'yachbat' ),
					]
				);

				$this->add_control(
					'tab_item_v2',
					[
						'label'       => esc_html__( 'Items Testimonial', 'yachbat' ),
						'type'        => Controls_Manager::REPEATER,
						'fields'      => $repeater2->get_controls(),
						'default' => [
							[
								'name_author' 	=> esc_html__('James thomas', 'yachbat'),
								'job' 			=> esc_html__('Some Company Name', 'yachbat'),
								'testimonial' 	=> esc_html__('Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy.', 'yachbat'),
							],
							[
								'name_author' 	=> esc_html__('Sofia brichet', 'yachbat'),
								'job' 			=> esc_html__('Some Company Name', 'yachbat'),
								'testimonial' 	=> esc_html__('There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don"t look even.', 'yachbat'),
							],
							[
								'name_author' 	=> esc_html__('Peek Thakul', 'yachbat'),
								'job' 			=> esc_html__('Governer Of Canada', 'yachbat'),
								'testimonial' 	=> esc_html__('Tools to network more effectively, including an orientation CD giving the Formula for Success" in BNI, a badge, a vinyl card holder to carry.', 'yachbat'),
							],
						],
						'title_field' 	=> '{{{ name_author }}}',
						'condition' 	=> [
							'version' 	=> 'version_2',
						],
					]
				);
			
		$this->end_controls_section();

		/*****************  END SECTION CONTENT ******************/


		/*****************************************************************
						START SECTION ADDITIONAL
		******************************************************************/

		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'yachbat' ),
			]
		);


		/***************************  VERSION 1 ***********************/
			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'yachbat' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'yachbat' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'yachbat' ),
					'default'     => 2,
				]
			);

			$this->add_control(
				'item_number_v2',
				[
					'label'       => esc_html__( 'Item Number', 'yachbat' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'yachbat' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'yachbat' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'yachbat' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'yachbat' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'yachbat' ),
						'no'  => esc_html__( 'No', 'yachbat' ),
					],
					'frontend_available' => true,
				]
			);


			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'yachbat' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'yachbat' ),
						'no'  => esc_html__( 'No', 'yachbat' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'yachbat' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => esc_html__( 'Yes', 'yachbat' ),
						'no'  => esc_html__( 'No', 'yachbat' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'yachbat' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'yachbat' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'yachbat' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'yachbat' ),
						'no'  => esc_html__( 'No', 'yachbat' ),
					],
					'frontend_available' => true,
					'condition' => [
						'version' => 'version_1',
					],
				]
			);

			

           
		//version 2 
			$this->add_control(
				'nav_control',
				[
					'label'   => __( 'Show Nav', 'yachbat' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => __( 'Yes', 'yachbat' ),
						'no'  => __( 'No', 'yachbat' ),
					],
					'frontend_available' => true,
					'condition' => [
						'version' => 'version_2',
					],
				]
			);

			$this->add_control(
				'nav_left',
				[
					'label' 		=> __( 'Nav left', 'yachbat' ),
					'type' 			=> Controls_Manager::TEXT,
					'default'		=> __('fas fa-angle-left', 'yachbat'),
					'condition' 	=> [
						'version' 		=> 'version_2',
						'nav_control' 	=> 'yes',
					]
				]
			);
			$this->add_control(
				'nav_right',
				[
					'label' 		=> __( 'Nav right', 'yachbat' ),
					'type' 			=> Controls_Manager::TEXT,
					'default' 		=> __('fas fa-angle-right', 'yachbat'),
					'condition' 	=> [
						'version' 		=> 'version_2',
						'nav_control' 	=> 'yes',
					]
				]
			);
			
		$this->end_controls_section();

		/****************************  END SECTION ADDITIONAL *********************/

		/*************  SECTION NAME JOB. *******************/
		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__( 'General', 'yachbat' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			

			$this->add_control(
				'quote_color',
				[
					'label'     => esc_html__( 'Quote Job', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial.version_2 .slide-testimonials .client_info .icon-quote span:before' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .icon-quote span::before' => 'color : {{VALUE}};',
						
					],
				]
			);

			$this->add_control(
				'dot_active_color',
				[
					'label'     => esc_html__( 'Dot Active Color', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial.version_2 .slide-testimonials .owl-dots .owl-dot.active span' => 'background : {{VALUE}};',
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .owl-dots .owl-dot.active span' => 'background : {{VALUE}};',
						
					],
				]
			);


		$this->end_controls_section();
		###############  end section job  ###############

		/*************  SECTION Icon. *******************/
		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__( 'Icon', 'yachbat' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'icon_color',
				[
					'label'     => esc_html__( 'Color', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial.version_2 .slide-testimonials .client_info .info>i::before' => 'color : {{VALUE}};',
					],
					'condition' => [
						'version' => 'version_2',
					],
				]
			);
			$this->add_responsive_control(
				'icon_size',
				[
					'label' 		=> esc_html__( 'Size', 'yachbat' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range' 		=> [
						'px' 	   => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial.version_2 .slide-testimonials .client_info .info i::before' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'version' => 'version_2',
					],
				]
			);

			
			$this->add_control(
				'icon_quote',
				[
					'label'     => esc_html__( 'Color quote', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .icon-quote i:before' => 'color : {{VALUE}};',
					],
					'condition' => [
						'version' => 'version_1',
					],
				]
			);
			$this->add_responsive_control(
				'icon_quote_size',
				[
					'label' 		=> esc_html__( 'Size quote', 'yachbat' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range'  		=> [
						'px' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .icon-quote i:before' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'version' => 'version_1',
					],
				]
			);

			$this->add_control(
				'icon_quote_v2',
				[
					'label'     => esc_html__( 'Color quote', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial.version_2 .slide-testimonials .client_info .info .testimonial-box i::before' => 'color : {{VALUE}} !important;',
					],
					'condition' => [
						'version' => 'version_2',
					],
				]
			);
			$this->add_responsive_control(
				'icon_quote_size_v2',
				[
					'label' 		=> esc_html__( 'Size quote', 'yachbat' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range' => [
						'px' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial.version_2 .slide-testimonials .client_info .info .testimonial-box i::before' => 'font-size: {{SIZE}}{{UNIT}} !important;',
					],
					'condition' => [
						'version' => 'version_2',
					],
				]
			);

		$this->end_controls_section();
		###############  end section icon  ###############

		/*************  SECTION content testimonial  *******************/
		$this->start_controls_section(
			'section_content_testimonial',
			[
				'label' => esc_html__( 'Content Testimonial', 'yachbat' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'content_testimonial_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info p.evaluate',
				]
			);

			$this->add_control(
				'content_color',
				[
					'label'     => esc_html__( 'Color', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info p.evaluate' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'evaluate_font_family',
				[
					'label' 	=> esc_html__( 'Font Family', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::FONT,
					'default' 	=> "Playfair Display",
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info p.evaluate' => 'font-family: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'content_margin',
				[
					'label'      => esc_html__( 'Margin', 'yachbat' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info p.evaluate' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'content_padding',
				[
					'label'      => esc_html__( 'Padding', 'yachbat' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info p.evaluate' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);


		$this->end_controls_section();
		###############  end section content testimonial  ###############


		/*************  SECTION NAME AUTHOR. *******************/
		$this->start_controls_section(
			'section_author_name',
			[
				'label' => esc_html__( 'Author Name', 'yachbat' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'author_name_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .name',
				]
			);

			$this->add_control(
				'author_name_color',
				[
					'label'     => esc_html__( 'Color Author', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'
						{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .name' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'author_name_margin',
				[
					'label'      => esc_html__( 'Margin', 'yachbat' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'author_name_padding',
				[
					'label'      => esc_html__( 'Padding', 'yachbat' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);


		$this->end_controls_section();
		###############  end section author  ###############


		/*************  SECTION NAME JOB. *******************/
		$this->start_controls_section(
			'section_job',
			[
				'label' => esc_html__( 'Job', 'yachbat' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'job_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .job',
				]
			);

			$this->add_control(
				'job_color',
				[
					'label'     => esc_html__( 'Color Job', 'yachbat' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'
						{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .job' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'job_margin',
				[
					'label'      => esc_html__( 'Margin', 'yachbat' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .job' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'job_padding',
				[
					'label'      => esc_html__( 'Padding', 'yachbat' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-testimonial .slide-testimonials .client_info .info .name-job .job' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);


		$this->end_controls_section();
		###############  end section job  ###############

	}

	protected function render() {

		$settings = $this->get_settings();

		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['margin']             = $settings['margin_items'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['rtl']				= is_rtl() ? true: false;

		$version  	 = $settings['version'];
		$tab_item    = $settings['tab_item'];
		$tab_item_v2 = $settings['tab_item_v2'];

		if( $version == 'version_1' ) {

			$data_options['items']   = $settings['item_number'];
			$data_options['dots']    = $settings['dot_control'] === 'yes' ? true : false;
			$data_options['nav']	 = false;

		} 
		if( $version == 'version_2' ) {
			$data_options['items']   = $settings['item_number_v2'];
			$data_options['dots']    =  false;
			$data_options['nav']     = ( isset( $settings['nav_control'] ) && $settings['nav_control'] === 'yes'  ) ? true : false;
		}
		?>

		<?php if( $version === 'version_1' ){ ?>

			<section class="ova-testimonial ">

					<div class="slide-testimonials owl-carousel owl-theme " data-options="<?php echo esc_attr( json_encode($data_options) ); ?>">
						<?php if( !empty($tab_item) ) : foreach ( $tab_item as $item ) : ?>
							<div class="item">
								<div class="client_info">	
									<div class="client">
										<?php if( $item['link']['url'] ) {  
											$target = $item['link']['is_external'] ? ' target="_blank"' : '';
											?>
											<a href="<?php echo esc_url( $item['link']['url'] ); ?>" <?php printf( $target ); ?> >
												<?php if( $item['image_author'] != '' ) { ?>
													<?php $alt = isset( $item['name_author'] ) && $item['name_author'] ? $item['name_author'] : esc_html__( 'testimonial','yachbat' ); ?>
													<?php if(isset( $item['image_author']['url'] ) && $item['image_author']['url']): ?>
														<img src="<?php echo esc_attr( $item['image_author']['url'] ); ?>" alt="<?php echo esc_attr( $alt ); ?>" >
													<?php endif; ?>
												<?php } ?>
											</a>
											<?php } else {?>
												<?php if( $item['image_author'] != '' ) { ?>
													<?php $alt = isset( $item['name_author'] ) && $item['name_author'] ? $item['name_author'] : esc_html__( 'testimonial','yachbat' ); ?>
													<?php if(isset( $item['image_author']['url'] ) && $item['image_author']['url']): ?>
														<img src="<?php echo esc_attr( $item['image_author']['url'] ); ?>" alt="<?php echo esc_attr( $alt ); ?>" >
													<?php endif; ?>
												<?php } ?>
											<?php } ?>
									</div>
									<div class="icon-quote">
										<i class="ovaicon ovaicon-left-quote-1"></i>
									</div>
									<div class="info">
										<?php if( $item['testimonial'] != '' ) : ?>
										<p class="evaluate">
											<?php echo esc_html( $item['testimonial'] ); ?>
										</p>
										<?php endif; ?>
										<div class="name-job">
											<?php if( $item['link']['url'] ) {  
												$target = $item['link']['is_external'] ? ' target="_blank"' : '';
													if( $item['name_author'] != '' ) { ?>
														<p class="name second_font">
															<a href="<?php echo esc_url( $item['link']['url'] ); ?>" <?php printf( $target ); ?> >
																<?php echo esc_html( $item['name_author'] ); ?>
															</a>
														</p>	
													<?php } 
												} else {
													if( $item['name_author'] != '' ) { ?>
														<p class="name second_font">
															<?php echo esc_html( $item['name_author'] ); ?>
														</p>
													<?php } 
												} ?>
											<?php if( $item['job'] != '' ) { ?>
												<p class="job">
													<?php echo esc_html( $item['job'] ); ?>
												</p>
											<?php } ?>
										</div>
									</div><!-- end info -->
								</div>
							</div>
						<?php endforeach; endif; ?>
					</div>

			</section>

		<?php } else{ ?>
			<section class="ova-testimonial version_2">

					<div class="slide-testimonials owl-carousel owl-theme " data-options="<?php echo esc_attr( json_encode($data_options) ); ?>">
						<?php if( !empty( $tab_item_v2 ) ) : foreach ( $tab_item_v2 as $item ) : ?>
							<div class="item">
								<div class="client_info">
									<div class="info">
										<i class="<?php echo esc_attr( $item['icon']['value'] ); ?>"></i>
										<div class="testimonial-box">
											<?php if( $item['testimonial'] != '' ) : ?>
												<i class="ovaicon ovaicon-left-quote-1"></i>
												<p class="evaluate second_font"><?php echo esc_html( $item['testimonial'] ); ?></p>
											<?php endif; ?>
										</div>
										
										<div class="client">
											<?php if( $item['link']['url'] ) {  
											$target = $item['link']['is_external'] ? ' target="_blank"' : '';
											?>
											<a href="<?php echo esc_url(  $item['link']['url'] ); ?>" <?php printf( $target ); ?> >
												<?php if( $item['image_author'] != '' ) { ?>
													<?php $alt = isset( $item['name_author'] ) && $item['name_author'] ? $item['name_author'] : esc_html__( 'testimonial','yachbat' ); ?>
													<?php if(isset( $item['image_author']['url'] ) && $item['image_author']['url']): ?>
														<img src="<?php echo esc_attr( $item['image_author']['url'] ); ?>" alt="<?php echo esc_attr( $alt ); ?>" >
													<?php endif; ?>
												<?php } ?>
											</a>
											<?php } else {?>
												<?php if( $item['image_author'] != '' ) { ?>
													<?php $alt = isset( $item['name_author'] ) && $item['name_author'] ? $item['name_author'] : esc_html__( 'testimonial','yachbat' ); ?>
													<?php if(isset( $item['image_author']['url'] ) && $item['image_author']['url']): ?>
														<img src="<?php echo esc_attr( $item['image_author']['url'] ); ?>" alt="<?php echo esc_attr( $alt ); ?>" >
													<?php endif; ?>
												<?php } ?>
											<?php } ?>
										</div>
										<div class="name-job">
												<?php if( $item['link']['url'] ) {  
													$target = $item['link']['is_external'] ? ' target="_blank"' : '';
														if( $item['name_author'] != '' ) { ?>
															<p class="name second_font">
																<a href="<?php echo esc_url( $item['link']['url'] ); ?>" <?php printf( $target ); ?> >
																	<?php echo esc_html( $item['name_author'] ); ?>
																</a>
															</p>	
														<?php } 
													} else {
														if( $item['name_author'] != '' ) { ?>
															<p class="name second_font">
																<?php echo esc_html( $item['name_author'] ); ?>
															</p>
														<?php } 
													} ?>
											<?php if( $item['job'] != '' ) { ?>
											<p class="job"><?php echo esc_html( $item['job'] ); ?></p>
											<?php } ?>
										</div>
									</div>
									<!-- end info -->
								</div>
							</div>
						<?php endforeach; endif; ?>
					</div>

			</section>
		<?php } ?>
		
		<?php
	}
	// end render
}

$widgets_manager->register( new Yachbat_Elementor_Testimonial_Carousel() );

