<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Yachbat_Elementor_Switch_Language extends Widget_Base {

	
	public function get_name() {
		return 'yachbat_elementor_switch_language';
	}

	
	public function get_title() {
		return esc_html__( 'Switch Language', 'yachbat' );
	}

	
	public function get_icon() {
		return 'eicon-global-settings';
	}

	
	public function get_categories() {
		return [ 'yachbat' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
			]
		);	
		
		$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'language', [
					'label' 		=> esc_html__( 'Title', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::TEXT,
					'default' 		=> esc_html__( 'EN' , 'yachbat' ),
					'label_block' 	=> true,
				]
			);

			$repeater->add_control(
				'list_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}'
					],
				]
			);

		$this->add_control(
			'list',
			[
				'label' 	=> esc_html__( 'Language', 'yachbat' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'language' => esc_html__( 'EN', 'yachbat' ), 
					],
					[
						'language' => esc_html__( 'Fr', 'yachbat' ),
					],
				],
				'title_field' => '{{{ language }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_switch_language',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'typography',
					'selector' => '{{WRAPPER}} .switch-language a',
				]
			);

			$this->start_controls_tabs('style_switch_language');

				$this->start_controls_tab(
					'style_normal',
					[
						'label' => esc_html__( 'Normal', 'yachbat' ),
					]
				);
					
					$this->add_control(
						'color',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .switch-language a' => 'color : {{VALUE}};',		
							],
						]
					);		

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_hover',
					[
						'label' => esc_html__( 'Hover', 'yachbat' ),
					]
				);
					$this->add_control(
						'color_hover',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .switch-language a:hover' => 'color : {{VALUE}};',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_control(
				'hr_border',
				[					
					'type'    => \Elementor\Controls_Manager::DIVIDER,
					'default' =>'after',
				]
			);
			
			$this->add_responsive_control(
				'padding',
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px'],
					'selectors' 	=> [
						'{{WRAPPER}} .switch-language' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		//END SECTION TAB STYLE 
		
		//END SECTION TAB separator STYLE 
		$this->start_controls_section(
			'section_switch_language_separator',
			[
				'label' => esc_html__( 'Separator', 'yachbat' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'color_separator',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type'  	=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .switch-language' => 'color : {{VALUE}};',			
					],
				]
			);

		$this->end_controls_section();
		//END SECTION TAB separator STYLE 
	}

	protected function render() {

		$settings 		= $this->get_settings();
	
		$list_language  = $settings['list'];
		$arr_count 		= count($list_language);
		?>
			<div class="switch-language">
				<?php
				$count = 0;

				foreach( $list_language as $item ) {
					$count++;
					if( $count <= $arr_count ) {
						if( $count == $arr_count ) {
							echo  '<a>' . $item['language'] . '</a>';
						} else {
							echo  '<a>' . $item['language'] . '</a>' . "/";
						}
					}
				}		
				?>
			</div>	
		<?php 
	}
}

$widgets_manager->register( new Yachbat_Elementor_Switch_Language() );