<?php
/**
 * Setup yachbat Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 */



add_action('rest_api_init', function () {
    register_rest_route('getyourguide', '1/get-availabilities', array(
        'methods' => 'GET',
        'callback' => 'get_availabilities1'
    ));
    register_rest_route('getyourguide', '1/reserve', array(
        'methods' => 'POST',
        'callback' => 'reserve_booking1'
    ));
    register_rest_route('getyourguide', '1/book', array(
        'methods' => 'POST',
        'callback' => 'book_charter1'
    ));
    register_rest_route('getyourguide', '1/cancel-reservation', array(
        'methods' => 'POST',
        'callback' => 'cancel_reservation1'
    ));
    register_rest_route('getyourguide', '1/cancel-booking', array(
        'methods' => 'POST',
        'callback' => 'cancel_booking1'
    ));
    register_rest_route('getyourguide', '1/cancel-reserve', array(
        'methods' => 'POST',
        'callback' => 'reservation1_cancel'
    ));
    
});

function set_rest_api_timezone() {
    $timezone_string = get_option('timezone_string');
    date_default_timezone_set($timezone_string);
}



/*
function woocommerce_product_custom_fields_save($post_id)
{
    // Custom Product Text Field
    $getyourguide_id = $_POST['getyourguide_id'];
    if (!empty($getyourguide_id)){
        update_post_meta($post_id, 'getyourguide_id', esc_attr($getyourguide_id));
    }
        
}
 // Save Fields
add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save');   


function woocommerce_product_custom_fields_display()
{
    global $woocommerce, $post;
    echo '<div class="product_custom_field">';
    // Custom Product Text Field
    woocommerce_wp_text_input(
        array(
            'id' => 'getyourguide_id',
            'placeholder' => 'Get your guide product id',
            'label' => __('Get your guide product id', 'woocommerce'),
            'desc_tip' => 'true'
        )
    );

    echo '</div>';
}
// Display Fields
add_action('woocommerce_product_options_general_product_data', 'woocommerce_product_custom_fields_display');
*/




function get_availabilities1() {
    set_rest_api_timezone();
    $fromDateTime_iso = isset($_GET['fromDateTime']) ? $_GET['fromDateTime'] : '';
    $toDateTime_iso = isset($_GET['toDateTime']) ? $_GET['toDateTime'] : '';
    $product_id_website = isset($_GET['productId']) ? $_GET['productId'] : '';
    

   // $product_id_website = get_product_id_from_meta( 'getyourguide_id', $input_gtg_prd_id );

    if (empty($fromDateTime_iso) || empty($toDateTime_iso) || empty($product_id_website)  ) {
        $response = array(
            "errorCode" => "INVALID_PRODUCT",
            "errorMessage" => "Input data is invalid"
        );
        return new WP_REST_Response($response);
        wp_die();
    }
    $fromDateTime_iso = str_replace(' ', '+', $fromDateTime_iso);
    $toDateTime_iso = str_replace(' ', '+', $toDateTime_iso);

    $FrmDateTime_obj = new DateTime($fromDateTime_iso);
    $toDateTime_obj = new DateTime($toDateTime_iso);

    $FrmDateTime_date = $FrmDateTime_obj->format('Y-m-d');
    $toDateTime_date = $toDateTime_obj->format('Y-m-d');

    $start_timestamp = strtotime($FrmDateTime_date);
    $end_timestamp = strtotime($toDateTime_date);

    $ovabrw_fromTime = get_post_meta($product_id_website, 'ovabrw_pehour_start_time', true);
    $ovabrw_toTime = get_post_meta($product_id_website, 'ovabrw_pehour_end_time', true);
    $ovabrw_low_peak_value = get_post_meta( $product_id_website, 'ovabrw_petime_ispeak', true );
    $ovabrw_boat_term_id = get_post_meta( $product_id_website, 'boat_term_id', true );

    //block timeslot by same boat booked
    $statuses_boat_block = array(
        'status' => array('wc-completed', 'wc-processing','wc-on-hold','wc-pending'),
        'limit' => -1,
        'date_query' => array(
            array(
                'after'     => $FrmDateTime_date,
                'before'    => $toDateTime_date,
                'inclusive' => true,
            )
        )
    );
    $orders = wc_get_orders($statuses_boat_block);
    
    foreach ($orders as $order) {
        $order_items = $order->get_items();

            foreach ( $order_items as $item_id => $item ) {
                $order_prd_id = $item->get_product_id();
                $order_term_id = get_post_meta( $order_prd_id, 'boat_term_id', true );
                if( $order_term_id == $ovabrw_boat_term_id){
                    $prepare_time = get_post_meta( $item->get_product_id(), 'ovabrw_prepare_vehicle', true ) ? get_post_meta( $item->get_product_id(), 'ovabrw_prepare_vehicle', true ) * 60 : 0;
                    foreach ( $item->get_formatted_meta_data() as $meta_id => $meta ) {
                        if( $meta->key == 'ovabrw_pickup_date' ){
                            $order_pickup_date = strtotime( $meta->value );
                        
                        }
            
                        if( $meta->key == 'ovabrw_pickoff_date_real' ){
                            $order_pickoff_date_store = strtotime( $meta->value ) + $prepare_time;
            
                        }
                    
                    }
                    if(!$order_pickoff_date_store){
                        $order_pickoff_date_store = $order_pickup_date + $prepare_time+60*60*1;
                    }
                  
                    $block_timestamp_range_list[]= array( "start" => $order_pickup_date, "end" => $order_pickoff_date_store, "order_id" => $order->get_id());
                }
            
            }

    }





$data = array();
while ($start_timestamp <= $end_timestamp) {

    $year = date('Y',$start_timestamp);

    $unavail_dec = $year.'-12-01';
    $unavail_feb = $year.'-03-01';

    $low_1 = $year.'-03-01';
    $low_2 = $year.'-05-16';
    $low_3 = $year.'-09-17';
    $low_4 = $year.'-12-01';

    $peak_1 = $year.'-05-16';
    $peak_2 = $year.'-09-17';

    if($start_timestamp >= strtotime($unavail_dec) || $start_timestamp <= strtotime($unavail_feb) || $start_timestamp >= (time()+60*60*24*365) ){
        $start_date_type = "unavailable";
        $data['availabilities'][] = array(
            'dateTime' => date('c', $start_timestamp),
            'openingTimes' => array(
                array('fromTime' => "10:00 AM")
            ),
            'productId' => $product_id_website,
            'cutoffSeconds' => 0,
            'vacancies' => 0
        );
        $start_timestamp = strtotime('+1 day', $start_timestamp); 
        continue;
    }elseif( ( $start_timestamp >= strtotime($low_1) && $start_timestamp <= strtotime($low_2) ) || ($start_timestamp >= strtotime($low_3) && $start_timestamp <= strtotime($low_4) ) ){
        $start_date_type = "low";
    }elseif($start_timestamp >= strtotime($peak_1) || $start_timestamp <= strtotime($peak_2)){
        $start_date_type = "peak";
    }


    foreach($ovabrw_fromTime as $index=>$ovabrw_fromTime_each){
        $ovabrw_toTime_each = $ovabrw_toTime[$index];
        $start_timestamp_to_date = date('Y-m-d', $start_timestamp);

        //block slot using boat term id of this boat which is already booked on this time range.
        $start_timestamp_package = strtotime($start_timestamp_to_date." ".$ovabrw_fromTime_each);
        $end_timestamp_package = strtotime($start_timestamp_to_date." ".$ovabrw_toTime_each);
        //End
        $block_current = false;
        foreach($block_timestamp_range_list as $block_timestamp_range_each){
            if( ($block_timestamp_range_each["start"] <= $start_timestamp_package && $block_timestamp_range_each["end"] > $start_timestamp_package)){
                $block_current = true;
            }
        }

        if(!$block_current){
            if( $start_date_type != "unavailable" && $start_date_type == "low" && $ovabrw_low_peak_value[$index] == 2){
                $data['availabilities'][] = array(
                    'dateTime' => date('c', $start_timestamp_package),
                    'productId' => $product_id_website,
                    'cutoffSeconds' => 0,
                    'vacancies' => 1
                );
            }elseif( $start_date_type != "unavailable" && $start_date_type == "peak" && $ovabrw_low_peak_value[$index] == 1){
                $data['availabilities'][] = array(
                    'dateTime' => date('c', $start_timestamp_package),
                    'productId' => $product_id_website,
                    'cutoffSeconds' => 0,
                    'vacancies' => 1
                );
            }
        }
        
    }

$start_timestamp = strtotime('+1 day', $start_timestamp);      
}
return new WP_REST_Response(array('data' => $data), 200);
wp_die();


}

function get_product_id_from_meta( $meta_key, $meta_value ) {
    global $wpdb;

    // Prepare SQL query to get post ID from postmeta table
    $query = $wpdb->prepare( "
        SELECT post_id
        FROM {$wpdb->postmeta}
        WHERE meta_key = %s
        AND meta_value = %s
    ", $meta_key, $meta_value );

    // Get the post ID from postmeta table
    $product_id = $wpdb->get_var( $query );
    return $product_id;
}

function reserve_booking1($request) {
    
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);
    
    if (empty($request_data['data']['bookingItems']) || empty($request_data['data']['dateTime']) || empty($request_data['data']['productId']) || empty($request_data['data']['gygBookingReference'])) {
        $response = array(
            "errorCode" => "INVALID_PRODUCT",
            "errorMessage" => "Invalid Input"
        );
        return new WP_REST_Response($response, 400);
        
    
    }
 
    $request_date_iso = $request_data['data']['dateTime'];
    $request_date_obj = new DateTime($request_date_iso);
    $request_date = $request_date_obj->format('Y-m-d h:i A');
  

    $category = $request_data['data']['bookingItems'][0]['category'];
    if ($category != 'GROUP') {
        $response = array(
            "errorCode" => "INVALID_TICKET_CATEGORY",
            "errorMessage" => "Invalid ticket category",
            "ticketCategory"=> "GROUP"
        );
        return new WP_REST_Response($response);
       
    }

    $groupSize = $request_data['data']['bookingItems'][0]['groupSize'];

    $product_id = $request_data['data']['productId'];
    $response_data = array();
     
    if ($groupSize > 11) {
        $response = array(
            "errorCode" => "NO_AVAILABILITY",
            "errorMessage" => "Group size is unable to accomodate. Maximum 11 pax supported",
        );
        return new WP_REST_Response($response);
        
        
    }
    $year = date('Y',strtotime($request_date));
    $unavail_dec = $year.'-12-01';
    $unavail_feb = $year.'-03-01';

    if (strtotime($request_date) >= strtotime($unavail_dec) || strtotime($request_date) <= strtotime($unavail_feb)) {
        $response = array(
            "errorCode" => "NO_AVAILABILITY",
            "errorMessage" => "No availability for the requested date and time."
        );
        return new WP_REST_Response($response);
        
       
    }
  
  //  $product_id = get_product_id_from_meta( 'getyourguide_id', $input_prd_id );
   
    if ($product_id) {
        $order = wc_create_order();
        
        $order->add_product(wc_get_product($product_id), 1);

        
        // $order->calculate_totals();
        
        $order->update_meta_data('gygBookingReference', $request_data['data']['gygBookingReference']);  
           
        foreach ($order->get_items() as $item_id => $item) {
            wc_add_order_item_meta($item_id, 'ovabrw_pickup_date', $request_date_obj->format('d-m-Y h:i A'));
            wc_add_order_item_meta($item_id, 'ovabrw_pickup_date_real', $request_date_obj->format('d-m-Y h:i A'));
                break;
        }

        $ovabrw_fromTime = get_post_meta($product_id, 'ovabrw_pehour_start_time', true);
        $ovabrw_toTime = get_post_meta($product_id, 'ovabrw_pehour_end_time', true);
        foreach($ovabrw_fromTime as $index=>$ovabrw_fromTime_each){
            if(strtotime($ovabrw_fromTime_each) == strtotime($request_date_obj->format('h:i A'))){
                $ovabrw_pickoff_time = $ovabrw_toTime[$index];
                wc_add_order_item_meta($item_id, 'ovabrw_pickoff_date', $request_date_obj->format('d-m-Y')." ".$ovabrw_pickoff_time);
                wc_add_order_item_meta($item_id, 'ovabrw_pickoff_date_real', $request_date_obj->format('d-m-Y')." ". $ovabrw_pickoff_time);
                break;
            }

        }

        $order->save();      
        $response_data = array(
            'data' => array(
                'reservationReference' => $order->get_order_number(),
                'reservationExpiration' => Date('c', strtotime("+1 hour"))
            )
        );
        $response = new WP_REST_Response($response_data, 200);
        return $response;
        
    }else {
            $response = array(
                "errorCode" => "INVALID_PRODUCT",
                "errorMessage" => "Invalid productId"
            );
            return new WP_REST_Response($response);
            
            
    }
  
}

function book_charter1($request) {
    set_rest_api_timezone();
    global $woocommerce;

    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);
    $max_group_size = 10;
    if (empty($request_data['data']['bookingItems']) || empty($request_data['data']['dateTime']) || empty($request_data['data']['currency']) || empty($request_data['data']['gygBookingReference']) || empty($request_data['data']['productId']) || empty($request_data['data']['reservationReference']) || empty($request_data['data']['travelers'])) {
        return new WP_REST_Response(array('error' => 'Invalid request data'), 400);
        wp_die();
    }

    $category = $request_data['data']['bookingItems'][0]['category'];
    if ($category != 'GROUP') {
        $response = array(
            "errorCode" => "INVALID_TICKET_CATEGORY",
            "errorMessage" => "Invalid ticket category",
            "ticketCategory"=> "GROUP"
        );
        return new WP_REST_Response($response);
        wp_die();
    }

    $groupSize = $request_data['data']['bookingItems'][0]['groupSize'];
    if ($groupSize > $max_group_size) {
        $response = array(
            "errorCode" => "NO_AVAILABILITY",
            "errorMessage" => "Group size is unable to accomodate. Maximum ".$max_group_size." pax supported",
        );
        return new WP_REST_Response($response);
        wp_die();
    }

    $request_date_iso = $request_data['data']['dateTime'];
    $request_date_obj = new DateTime($request_date_iso);
    $request_date = $request_date_obj->format('Y-m-d h:i A');


    $product_id = $request_data['data']['productId'];

   // $product_id = get_product_id_from_meta( 'getyourguide_id', $input_prd_id );

    if (!$product_id) {
        $response = array(
            "errorCode" => "INVALID_PRODUCT",
            "errorMessage" => "Invalid productId"
        );
        return new WP_REST_Response($response);
        wp_die();
    }

    $order_id = $request_data['data']['reservationReference'];
    $order = new WC_Order($order_id);

    if (!$order || empty($order_id)) {
        $response = array(
            "errorCode" => "INVALID_RESERVATION",
            "errorMessage" => "Expired reservation; 60min hold time was exceeded."
        );
        return new WP_REST_Response($response);
        wp_die();
    }

    $address = array(
        'first_name' => $request_data['data']['travelers'][0]['firstName'],
        'last_name'  => $request_data['data']['travelers'][0]['lastName'],
        'company'    => '',
        'email'      => $request_data['data']['travelers'][0]['email'],
        'phone'      => $request_data['data']['travelers'][0]['phoneNumber'],
        'address_1'  => '',
        'address_2'  => '',
        'city'       => '',
        'state'      => '',
        'postcode'   => '',
        'country'    => ''
    );

    $order->set_address($address, 'billing');

    $order->update_status('completed', 'order_note');
    $order->save();
    foreach ($order->get_items() as $item_id => $item) {
        wc_update_order_item_meta($item_id, 'ovabrw_pickup_date', $request_date_obj->format('d-m-Y h:i A'));
        wc_update_order_item_meta($item_id, 'ovabrw_pickup_date_real', $request_date_obj->format('d-m-Y h:i A'));
        break;
    }
    
    

    $currentMicrotime = microtime();
    $currentMicrotime = str_replace([' ', '.'], '', $currentMicrotime);
    $ticketCode = "TKT-" . $currentMicrotime;
    $tickets = array();

    $item_count = count($request_data['data']['bookingItems']);

    for ($i = 0; $i < $item_count; $i++) {
        $tickets[] = array(
            'category' => 'GROUP',
            'ticketCode' => $ticketCode . $i,
            'ticketCodeType' => 'QR_CODE'
        );
    }

    $response_data = array(
        'data' => array(
            'bookingReference' => $order->get_order_number(),
            'tickets' => $tickets
        )
    );


    $response = new WP_REST_Response($response_data, 200);
   // if ($response->status === 200) {
       // send_push_notification_booking($order, $input_prd_id);
    //}
    return $response;
    wp_die();
}



function cancel_reservation1($request) {
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);

    if (empty($request_data['data']['reservationReference']) || empty($request_data['data']['gygBookingReference'])) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
        wp_die();
    }

    $order_id = $request_data['data']['reservationReference'];


    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
        wp_die();
    }

    $order->update_status('cancelled');
    $order->save();


    $response_data = ['data' => []];


    $response = new WP_REST_Response($response_data, 200);
    // if ($response->status === 200) {
    //     send_push_notification_cancel($order);
    // }
    return $response;
    wp_die();
}



function cancel_booking1($request) {
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);

    if (empty($request_data['data']['bookingReference']) || empty($request_data['data']['gygBookingReference']) || empty($request_data['data']['productId'])) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
    }

    $order_id = $request_data['data']['bookingReference'];
    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
        wp_die();
    }

    $order->update_status('cancelled');
    $order->save();

    $response =  new WP_REST_Response(array('data' => array()), 200);
    //if ($response->status === 200) {
        //send_push_notification_cancel($order);
   // }
    return $response;
    wp_die();
}


function reservation1_cancel($request) {
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);

    if (empty($request_data['data']['reservationReference']) || empty($request_data['data']['gygBookingReference'])) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
        wp_die();
    }

    $order_id = $request_data['data']['reservationReference'];
    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
        wp_die();
    }

    $order->update_status('cancelled');
    $order->save();

    $response =  new WP_REST_Response(array('data' => array()), 200);
    // if ($response->status === 200) {
    //     send_push_notification_cancel($order);
    // }
    return $response;
    wp_die();
}

function notify_availability_update($prd_id_ordered, $availabilities) {
    
    $url = 'https://supplier-api.test.com/1/notify-availability-update';
    $username = 'A1BoatChartersLtd';
    $password = '7f9efd61e934ac8f5b1bd3c6aa00945b';


    $args = array(
        'headers' => array(
            'Content-Type' => 'application/json',
            'Authorization' => 'Basic ' . base64_encode( $username . ':' . $password ),
        ),
        'body' => json_encode(array(
            'data' => array(
                'productId' => $prd_id_ordered,
                'availabilities' => $availabilities
            )
        )),
    );

    $response = wp_remote_post( $url, $args );

    if ( is_wp_error( $response ) ) {
        $error_message = $response->get_error_message();
        return new WP_REST_Response(array('error' => $error_message), 500);
        wp_die();
    } else {
        $body = wp_remote_retrieve_body( $response );
        return new WP_REST_Response($body, 200);
         wp_die();
    }
}

function send_push_notification_booking($order,$prd_id) {
    $items = $order->get_items();
    $push_notification_result = array();
    foreach ($items as $item) {
        $prd_id_ordered = $item->get_product_id();
       // $prd_id_gtg_item = get_post_meta($prd_id_ordered, 'getyourguide_id', true);
        if ($prd_id_ordered == $prd_id) {

            $availabilities =  [
                        array(
                            "dateTime"=> date('c', strtotime($item->get_meta('ovabrw_pickup_date'))),
                            "vacancies"=> 0
                        )];
        
            $push_notification_result[]= notify_availability_update($prd_id_ordered, $availabilities); 
           

        }
    }
}

function send_push_notification_cancel($order) {
    $items = $order->get_items();
    $push_notification_result = array();
    foreach ($items as $item) {
        $prd_id_ordered = $item->get_product_id();
       // $prd_id_gtg_item = get_post_meta($prd_id_ordered, 'getyourguide_id', true);

            $availabilities =  [
                        array(
                            "dateTime"=> date('c', strtotime($item->get_meta('ovabrw_pickup_date'))),
                            "vacancies"=> 1
                        )];
        
            $push_notification_result[]= notify_availability_update($prd_id_ordered, $availabilities);            

    }
}