<?php
/**
 * Setup yachbat Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 */
function create_boat_taxonomy() {

$labels = array(
    'name'              => _x( 'Boats', 'taxonomy general name', 'textdomain' ),
    'singular_name'     => _x( 'Boat', 'taxonomy singular name', 'textdomain' ),
    'search_items'      => __( 'Search Boats', 'textdomain' ),
    'all_items'         => __( 'All Boats', 'textdomain' ),
    'parent_item'       => __( 'Parent Boat', 'textdomain' ),
    'parent_item_colon' => __( 'Parent Boat:', 'textdomain' ),
    'edit_item'         => __( 'Edit Boat', 'textdomain' ),
    'update_item'       => __( 'Update Boat', 'textdomain' ),
    'add_new_item'      => __( 'Add New Boat', 'textdomain' ),
    'new_item_name'     => __( 'New Boat Name', 'textdomain' ),
    'menu_name'         => __( 'Boats', 'textdomain' ),
);

$args = array(
    'hierarchical'      => true,
    'labels'            => $labels,
    'show_ui'           => true,
    'show_admin_column' => true,
    'query_var'         => true,
    'rewrite'           => array( 'slug' => 'boat' ),
);

register_taxonomy( 'boat', array( 'product' ), $args );

}
add_action( 'init', 'create_boat_taxonomy', 0 );

function woocommerce_product_custom_fields_display_boat()
{
global $woocommerce, $post;
$boat_term_id = get_post_meta($post->ID, 'boat_term_id', true);
if(!isset($boat_term_id)){
    $boat_term_id = '';
}
echo '<div class="product_custom_field">';
$boats = get_terms( array(
    'taxonomy'   => 'boat',
    'hide_empty' => false,
) );
$boat_option = array('' =>__( 'Select a Boat', 'woocommerce' ));

foreach($boats as $boat){
    $boat_option[$boat->term_id]= $boat->name;  
}

echo get_the_term_list( $post->ID, 'boat', '<div">', '</div>', '' ); 
woocommerce_wp_select( array( // Text Field type
    'id'          => 'boat_select',
    'label'       => __( 'Select a Boat', 'woocommerce' ),
    'description' => __( 'Boats used in charter.', 'woocommerce' ),
    'desc_tip'    => true,
     'value'    => $boat_term_id,
    'options'     => $boat_option,
    'custom_attributes' => array(
                            'requred' => 'required'
                        )
) );

echo '</div>';
}
// Display Fields
add_action('woocommerce_product_options_general_product_data', 'woocommerce_product_custom_fields_display_boat');


function woocommerce_product_custom_fields_save_boat($post_id)
{
// Custom Product Text Field
$boat_term_id = $_POST['boat_select'];
if (!empty($boat_term_id)){
    update_post_meta($post_id, 'boat_term_id', esc_attr($boat_term_id));
}
    
}
// Save Fields
add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save_boat');  



remove_action( 'wp_ajax_ovabrw_get_package_by_time', 'ovabrw_get_package_by_time_cus' );
remove_action( 'wp_ajax_nopriv_ovabrw_get_package_by_time', 'ovabrw_get_package_by_time_cus' );
add_action( 'wp_ajax_ovabrw_get_package_by_time', 'ovabrw_get_package_by_time_cus_custom' );
add_action( 'wp_ajax_nopriv_ovabrw_get_package_by_time', 'ovabrw_get_package_by_time_cus_custom' );
function ovabrw_get_package_by_time_cus_custom() {

	$id = isset($_POST['post_id']) ? sanitize_text_field( $_POST['post_id'] ) : '';
	$start_date = isset($_POST['startdate']) ? strtotime( $_POST['startdate'] ) : '';
  
	
	 // Total Car in $start_datethe Store
    $total_car_store = ovabrw_get_total_stock( $id );
    
    $post_array_id = ovabrw_get_wpml_product_ids( $id );
    $statuses = brw_list_order_status();
    $orders_ids = ovabrw_get_orders_by_product_id( $id, $statuses );

    $fromTime = get_post_meta($id, 'ovabrw_pehour_start_time', true);
    $toTime = get_post_meta($id, 'ovabrw_pehour_end_time', true);
$start_date_date = date("Y-m-d", $start_date);

    $year = date('Y',$start_date);
   

$unavail_dec = $year.'-12-01';
$unavail_feb = $year.'-02-28';

$low_1 = $year.'-03-01';
$low_2 = $year.'-05-15';
$low_3 = $year.'-09-17';
$low_4 = $year.'-11-30';

$peak_1 = $year.'-05-16';
$peak_2 = $year.'-09-16';


$start_date_type = "";

    if($start_date >= (time()+60*60*24*540) ){
        $start_date_type = "date_beyond_limit";
    
    }elseif($start_date >= strtotime($unavail_dec) || $start_date <= strtotime($unavail_feb) ){
        $start_date_type = "unavailable";
       
    }elseif( ( $start_date >= strtotime($low_1) && $start_date <= strtotime($low_2) ) || ($start_date >= strtotime($low_3) && $start_date <= strtotime($low_4) ) ){
        $start_date_type = "low";
    }elseif($start_date >= strtotime($peak_1) || $start_date <= strtotime($peak_2)){
        $start_date_type = "peak";
    }
    if($start_date == ''){
        $start_date_type = "no_date_input";
     }

    $car_using_this_time = array();

    // Get list package of period time
	$ovabrw_petime_id	= get_post_meta( $id, 'ovabrw_petime_id', true );

	$ovabrw_petime_label = get_post_meta( $id, 'ovabrw_petime_label', true );
    $ovabrw_petime_ispeak = get_post_meta( $id, 'ovabrw_petime_ispeak', true );
    $boat_term_id_requested = get_post_meta( $id, 'boat_term_id', true );
    $term_ordered = array();
    $prdlist_termid = array();



//This loop Fetchs term id-orders from all available orders
$args = array(
    'status' => array('wc-completed', 'wc-on-hold', 'wc-pending'),
    'limit' => -1
);
$orders = wc_get_orders($args);
foreach ($orders as $order) {
    $ord_items = $order->get_items();
    foreach ($ord_items as $ord_item) {
        $prd_id_ordered = $ord_item->get_product_id();
        $boat_term_id_ordered = get_post_meta( $ord_item->get_product_id(), 'boat_term_id', true );
        $prepare_time = get_post_meta( $ord_item->get_product_id(), 'ovabrw_prepare_vehicle', true ) ? get_post_meta( $ord_item->get_product_id(), 'ovabrw_prepare_vehicle', true ) * 60 : 0;
          // Get value of pickup date, pickoff date
         
          foreach ( $ord_item->get_formatted_meta_data() as $meta_id => $meta ) {
            if( $meta->key == 'ovabrw_pickup_date' ){
                $ovabrw_pickup_date_store = strtotime( $meta->value );
            }

            if( $meta->key == 'ovabrw_pickoff_date_real' ){
                $ovabrw_pickoff_date_store = strtotime( $meta->value ) + $prepare_time;

            }
            if( $meta->key == 'id_vehicle' ){
                $id_vehicle = trim( $meta->value );
            }
            if( $meta->key == 'ovabrw_number_vehicle' ){
                $quantity = intval( $meta->value );
            }
        }
       
           
            $ovabrw_pickup_date_store_date = date("Y-m-d", $ovabrw_pickup_date_store);
            $ovabrw_pickoff_date_store_date = date("Y-m-d", $ovabrw_pickoff_date_store);
   
            
            if($boat_term_id_ordered  == $boat_term_id_requested && $ovabrw_pickup_date_store_date == $start_date_date){

                $term_ordered[]= array(
                    "term_id" => $boat_term_id_ordered,
                    "pickup_date" => date("Y-m-d g:i A", $ovabrw_pickup_date_store),
                    "pickoff_date" => date("Y-m-d g:i A", $ovabrw_pickoff_date_store),
                    'productId' => $ord_item->get_product_id() 
                );


               
            }
        
    }
}





    // For Order ID -  This loop is the order of request product only
    foreach ($orders_ids as $key => $value) {

        // Get Order Detail by Order ID
        $order = wc_get_order($value);

        // Get Meta Data type line_item of Order
        $order_items = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
        
       
        // For Meta Data
        foreach ( $order_items as $item_id => $item ) {

            $ovabrw_pickup_date_store = $ovabrw_pickoff_date_store = $id_vehicle = $quantity = '';

            // Check Line Item have item ID is Car_ID
            if( in_array( $item->get_product_id(), $post_array_id ) ){

                // Check time to Prepare before delivered
                $prepare_time = get_post_meta( $id, 'ovabrw_prepare_vehicle', true ) ? get_post_meta( $id, 'ovabrw_prepare_vehicle', true ) * 60 : 0;


                // Get value of pickup date, pickoff date
                foreach ( $item->get_formatted_meta_data() as $meta_id => $meta ) {
                    if( $meta->key == 'ovabrw_pickup_date' ){
                        $ovabrw_pickup_date_store = strtotime( $meta->value );
                    }
                    if( $meta->key == 'ovabrw_pickoff_date_real' ){
                        $ovabrw_pickoff_date_store = strtotime( $meta->value ) + $prepare_time;
                    }
                    if( $meta->key == 'id_vehicle' ){
                        $id_vehicle = trim( $meta->value );
                    }
                    if( $meta->key == 'ovabrw_number_vehicle' ){
                        $quantity = intval( $meta->value );
                    }
                }

            //     $boat_term_id_ordered = get_post_meta( $item->get_product_id(), 'boat_term_id', true );
            //    $ovabrw_pickup_date_store_date = date("Y-m-d", $ovabrw_pickup_date_store);
            //    $ovabrw_pickoff_date_store_date = date("Y-m-d", $ovabrw_pickoff_date_store);
            //     $start_date_date = date("Y-m-d", $start_date);
            //     $fromTime_ordered = get_post_meta($item->get_product_id(), 'ovabrw_pehour_start_time', true);
            //     $toTime_ordered = get_post_meta($item->get_product_id(), 'ovabrw_pehour_end_time', true);

                // foreach ($fromTime_ordered as $index => $fromTime_each &&) {
                //     $date_time_ordered = $start_date_date . " " . $fromTime_each;
                //     $prdlist_termid[]= array(
                //         'dateTime' => $date_time_ordered,
                //         'fromTime' => $fromTime_each,
                //         'toTime' => $toTime_ordered[$index],
                //         'productId' => $item->get_product_id(),
                //         'term_id' => $boat_term_id_ordered,
                //     );
                // }
                
                
                // if($boat_term_id_ordered  == $boat_term_id_requested && $ovabrw_pickup_date_store_date == $start_date_date){

                //     $term_ordered[]= array(
                //         "term_id" => $boat_term_id_ordered,
                //         "pickup_date" => date("Y-m-d g:i A", $ovabrw_pickup_date_store),
                //         "pickoff_date" => date("Y-m-d g:i A", $ovabrw_pickoff_date_store),
                //         'productId' => $item->get_product_id() 
                //     );


                 
                // }
                


                // Only compare date when "PickOff Date in Store" > "Current Time" becaue "PickOff Date Rent" have to > "Current Time"
                if( $ovabrw_pickoff_date_store >= current_time( 'timestamp' ) && ( $id_vehicle != '' || $quantity ) ){
                    
				    if( $ovabrw_petime_id ){ 
				        foreach ( $ovabrw_petime_id as $petime_id ) {

				        	$start_end_time_package = get_rental_info_period( $id, $start_date, 'period_time', $petime_id );
				        	$ovabrw_pickup_date = $start_end_time_package['start_time'];
				        	$ovabrw_pickoff_date = $start_end_time_package['end_time'];

				        	// Check rent time
		                    if( ! ($ovabrw_pickoff_date <= $ovabrw_pickup_date_store || $ovabrw_pickoff_date_store <= $ovabrw_pickup_date ) ){
		                    	for($i = 0; $i < $quantity; $i++ ) {
		                    		array_push( $car_using_this_time, $petime_id );
		                    	}
		                        
		                    }

				        }
				    }
                    

                }
                
            }

        }

    }



    // Package available
    $pack_avail = array();
    $pack_avail_low = array();
    $pack_avail_peak = array();

    if( $ovabrw_petime_id ){ 
		foreach ( $ovabrw_petime_id as $key => $petime_id ) {

			$i = 0;
			foreach ($car_using_this_time as $v) {
				if( $petime_id == $v ){
					$i ++;
				}
			}
			if( $i < $total_car_store ){
                if($start_date_type == 'low' && $ovabrw_petime_ispeak[$key] == 2 ){
                    $fromTime_pack = $fromTime[$key];
                    $fromTime_final = $start_date_date." ".$fromTime_pack;

                    $toTime_pack = $toTime[$key];
                    $toTime_final = $start_date_date." ".$toTime_pack;
                    $boat_available  = true;
                    foreach($term_ordered as $term_ordered_each){
                       
                        if(strtotime($fromTime_final) >= strtotime($term_ordered_each['pickup_date']) && strtotime($fromTime_final) <= strtotime($term_ordered_each['pickoff_date']) || strtotime($toTime_final) >= strtotime($term_ordered_each['pickup_date']) && strtotime($toTime_final) <= strtotime($term_ordered_each['pickoff_date'])){
                            $boat_available  = false;
                        }
                    }
                    if($boat_available){
                        $pack_avail_low[ $petime_id ] = $ovabrw_petime_label[$key];
                    }
                    

                }elseif($start_date_type == 'peak'  && $ovabrw_petime_ispeak[$key] == 1 ){
                    $fromTime_pack = $fromTime[$key];
                    $fromTime_final = $start_date_date." ".$fromTime_pack;

                    $toTime_pack = $toTime[$key];
                    $toTime_final = $start_date_date." ".$toTime_pack;
                    $boat_available  = true;
                   
                    foreach($term_ordered as $term_ordered_each){
                        
                        if(strtotime($fromTime_final) >= strtotime($term_ordered_each['pickup_date']) && strtotime($fromTime_final) <= strtotime($term_ordered_each['pickoff_date']) || strtotime($toTime_final) >= strtotime($term_ordered_each['pickup_date']) && strtotime($toTime_final) <= strtotime($term_ordered_each['pickoff_date'])){
                            $boat_available  = false;
                            
                        }
                    }
                    if($boat_available){
                        $pack_avail_peak[ $petime_id ] = $ovabrw_petime_label[$key];
                    }
                    
                }elseif($start_date_type == 'no_date_input'){
                    
                        $pack_avail_nodate[ $petime_id ] = $ovabrw_petime_label[$key];

                    
                }elseif($start_date_type == 'unavailable' ){
                    $pack_avail = array( esc_html__( 'This is Off-season.', 'ova-brw' ) );
         
                }elseif($start_date_type == 'date_beyond_limit' ){
                    $pack_avail = array( esc_html__( 'This is date is beyond the limit.', 'ova-brw' ) );
         
                }
				
				
			} 
			
		}
     
	}



    if($start_date_type == 'low'){
        $pack_avail = $pack_avail_low;
    }elseif($start_date_type == 'peak'){
        $pack_avail = $pack_avail_peak;
    }elseif($start_date_type == 'no_date_input'){
        $pack_avail = $pack_avail_nodate;
    }

 

	if ( !isset( $pack_avail ) || empty( $pack_avail ) ) {
		$pack_avail = array( esc_html__( 'This date is unavailable or booked.', 'ova-brw' ) );

	}

   

	echo json_encode( $pack_avail );

	wp_die();
}


function woocommerce_product_custom_fields_save_ispeaktime($post_id)
{

   $ovabrw_petime_ispeak = isset($_POST['ovabrw_petime_ispeak']) ? $_POST['ovabrw_petime_ispeak'] : 0;

    foreach($ovabrw_petime_ispeak as $index=> $ovabrw_petime_ispeak_each){
        $ovabrw_petime_ispeak[$index] = $ovabrw_petime_ispeak_each[0];
    }

   if(!empty($ovabrw_petime_ispeak)){
    update_post_meta( $post_id, 'ovabrw_petime_ispeak', $ovabrw_petime_ispeak );
   }
   
}

 // Save Fields
add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save_ispeaktime');