<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */



add_action( 'cmb2_init', 'ova_team_metaboxes' );
function ova_team_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'ova_team_met_';
    
    /* Team Settings ***************************************************************************/
    /* ************************************************************************************/
    $team_settings = new_cmb2_box( array(
        'id'            => 'ovateam_settings',
        'title'         => esc_html__( 'Team settings', 'ova-team' ),
        'object_types'  => array( 'team'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
        
    ) );

        // Avata
        $team_settings->add_field( array(
            'name'       => esc_html__( 'Avatar', 'ova-team' ),
            'description' => esc_html__( 'Use in Team Detail', 'ova-team' ),
            'id'         => $prefix . 'avatar',
            'type'    => 'file',
            'query_args' => array(
                'type' => array(
                    'image/gif',
                    'image/jpeg',
                    'image/png',
                ),
            ),
        ) );


        // Job
        $team_settings->add_field( array(
            'name'       => esc_html__( 'Job', 'ova-team' ),
            'id'         => $prefix . 'job',
            'type'    => 'text',
        ) );
       
        // Email
        $team_settings->add_field( array(
            'name'       => esc_html__( 'Email', 'ova-team' ),
            'id'         => $prefix . 'email',
            'type' => 'text_email',
        ) );

        // Phone
        $team_settings->add_field( array(
            'name'       => esc_html__( 'Phone', 'ova-team' ),
            'id'         => $prefix . 'phone',
            'type'    => 'text',
        ) );

        // Address
        $team_settings->add_field( array(
            'name'       => esc_html__( 'Address', 'ova-team' ),
            'id'         => $prefix . 'address',
            'type'    => 'text',
        ) );

        $team_settings->add_field( array(
            'name'       => esc_html__( 'Link Address', 'ova-team' ),
            'id'         => $prefix . 'link_address',
            'type'    => 'text_url',
        ) );

        // Short Description
        $team_settings->add_field( array(
            'name'       => esc_html__( 'Short Description', 'ova-team' ),
            'id'         => $prefix . 'short_desc',
            'type'       => 'textarea',
        ) );


        // Social
        $group_icon = $team_settings->add_field( array(
            'id'          => $prefix . 'group_icon',
            'type'        => 'group',
            'description' => esc_html__( 'List Social', 'ova-team' ),
            'options'     => array(
                'group_title'       => esc_html__( 'Social', 'ova-team' ), 
                'add_button'        => esc_html__( 'Add Social', 'ova-team' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-team' ),
                'sortable'          => true,
               
            ),
        ) );

        $team_settings->add_group_field( $group_icon, array(
            'name' => esc_html__( 'Class icon social', 'ova-team' ),
            'id'   => $prefix . 'class_icon_social',
            'type' => 'text',
        ) );


         $team_settings->add_group_field( $group_icon, array(
            'name' => esc_html__( 'Link social', 'ova-team' ),
            'id'   => $prefix . 'link_social',
            'type' => 'text_url',
        ) );

        // Language
        $group_language = $team_settings->add_field( array(
            'id'          => $prefix . 'group_language',
            'type'        => 'group',
            'description' => esc_html__( 'Language', 'ova-team' ),
            'options'     => array(
                'group_title'       => esc_html__( 'Language', 'ova-team' ), 
                'add_button'        => esc_html__( 'Add Language', 'ova-team' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-team' ),
                'sortable'          => true,
               
            ),
        ) );

         $team_settings->add_group_field( $group_language, array(
            'name' => esc_html__( 'Language', 'ova-team' ),
            'id'   => $prefix . 'name_lang',
            'type' => 'text',
        ) );       

        $team_settings->add_group_field( $group_language, array(
            'name' => esc_html__( 'Percent(%)', 'ova-team' ),
            'id'   => $prefix . 'lang_percent',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
            ),
        ) );

         // Education
        $group_education = $team_settings->add_field( array(
            'id'          => $prefix . 'group_education',
            'type'        => 'group',
            'description' => esc_html__( 'Education', 'ova-team' ),
            'options'     => array(
                'group_title'       => esc_html__( 'Education', 'ova-team' ), 
                'add_button'        => esc_html__( 'Add Education', 'ova-team' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-team' ),
                'sortable'          => true,
               
            ),
        ) );

        $team_settings->add_group_field( $group_education, array(
            'name' => esc_html__( 'Degree', 'ova-team' ),
            'id'   => $prefix . 'edu_degree',
            'type'    => 'text',
        ) );

        $team_settings->add_group_field( $group_education, array( 
            'name' => esc_html__( 'Year', 'ova-team' ),
            'id'   => $prefix . 'edu_year',
            'type' => 'text',
        ) );    

        $team_settings->add_group_field( $group_education, array(
            'name' => esc_html__( 'College/University', 'ova-team' ),
            'id'   => $prefix . 'edu_uni',
            'type'    => 'text',
        ) );   

        $team_settings->add_group_field( $group_education, array(
            'name' => esc_html__( 'Description', 'ova-team' ),
            'id'   => $prefix . 'edu_desc',
            'type'    => 'text',
        ) );

        // Achievements
        $group_achievements = $team_settings->add_field( array(
            'id'          => $prefix . 'group_achievements',
            'type'        => 'group',
            'description' => esc_html__( 'Achievements', 'ova-team' ),
            'options'     => array(
                'group_title'       => esc_html__( 'Achievements', 'ova-team' ), 
                'add_button'        => esc_html__( 'Add Achievements', 'ova-team' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-team' ),
                'sortable'          => true,
               
            ),
        ) );

         $team_settings->add_group_field( $group_achievements, array(
            'name' => esc_html__( 'Topic', 'ova-team' ),
            'id'   => $prefix . 'achi_topic',
            'type' => 'text',
        ) );       

        $team_settings->add_group_field( $group_achievements, array(
            'name' => esc_html__( 'Percent(%)', 'ova-team' ),
            'id'   => $prefix . 'achi_percent',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
            ),
        ) );

        // Experience short 1
        $team_settings->add_field( array(
            'name'       => esc_html__( 'Experience Short Description 1', 'ova-team' ),
            'id'         => $prefix . 'experience_1',
            'type'       => 'textarea',
        ) );

        // Experience
        $group_experience = $team_settings->add_field( array(
            'id'          => $prefix . 'group_experience',
            'type'        => 'group',
            'description' => esc_html__( 'Experience', 'ova-team' ),
            'options'     => array(
                'group_title'       => esc_html__( 'Experience', 'ova-team' ), 
                'add_button'        => esc_html__( 'Add Experience', 'ova-team' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-team' ),
                'sortable'          => true,
               
            ),
        ) );

         $team_settings->add_group_field( $group_experience, array(
            'name' => esc_html__( 'Year', 'ova-team' ),
            'id'   => $prefix . 'exp_year',
            'type' => 'text',
        ) );       

        $team_settings->add_group_field( $group_experience, array(
            'name' => esc_html__( 'Description', 'ova-team' ),
            'id'   => $prefix . 'exp_desc',
            'type'    => 'wysiwyg',
        ) );

        // Experience excerpt 2
        $team_settings->add_field( array(
            'name'    => esc_html__( 'Experience Short Description 2', 'ova-team' ),
            'id'      => $prefix . 'experience_2',
            'type'    => 'textarea',
        ) );

        $team_settings->add_field( array(
            'name'       => esc_html__( 'Sort Order', 'ova-team' ),
            'id'         => $prefix . 'order_team',
            'desc' => esc_html__( 'Insert Number', 'ova-team' ),
            'type'    => 'text',
            'default' =>'1',
        ) );


    }

