<?php if( ! defined( 'ABSPATH' ) ) exit();

extract( $args );   

// Get first day in week
$first_day 		 = get_option( 'ova_brw_calendar_first_day', '0' );
$dateformat 	 = ovabrw_get_date_format();
$placeholder 	 = ovabrw_get_placeholder_date_format( $dateformat );
$hour_default 	 = ovabrw_get_setting( get_option( 'ova_brw_booking_form_default_hour', '07:00' ) );
$time_step 		 = ovabrw_get_setting( get_option( 'ova_brw_booking_form_step_time', '30' ) );
$show_time       = $args['show_time'] === "yes" ? "true" : "false";
$title           = $args['booking_title'];
$action 		 = home_url();
if ( 'default' != $args['search_result'] ) {
	$action = $args['search_result_url']['url'];
}

$check_in_label  = $args['check_in_label'];
$check_out_label = $args['check_out_label'];
$guests_label 	 = $args['guests_label'];
$package_label 	 = $args['package_label'];
$package_items 	 = $args['package_items'];
$show_package    = $args['show_package'];  

$button_label 	 = $args['button_label'];
$adults_label 	 = $args['adults_label'];
$max_adult 		 = $args['max_adult'];
$min_adult 		 = $args['min_adult'];
$childrens_label = $args['childrens_label'];
$max_children    = $args['max_children'];
$min_children 	 = $args['min_children'];
$class_icon      = $args['icon']['value'];

$default_adult_number    = absint( $args['default_adult_number'] );
$default_children_number = absint( $args['default_children_number'] );
$gueststotal = $default_adult_number + $default_children_number;

$package_placeholder     = $args['package_placeholder'];
$guests_placeholder      = $args['guests_placeholder'];

?>

<div class="ovabrw-search2">
	<?php if( !empty( $class_icon ) ) { ?>
	    <i class="main-icon <?php echo esc_attr($class_icon); ?>"></i>
	<?php } ?>
	<h3 class="booking-title"><?php echo esc_html( $title ); ?></h3>
	<form action="<?php echo esc_url( $action ); ?>" method="GET" class="ovabrw-search2-form">
		<div class="ovabrw-s-field">
            
          
	        <?php if( ( $show_package === 'yes' ) && is_array( $package_items ) ) : ?>

                <div class="search-field">
                	<div class="ovabrw-input">
                		<fieldset>
	                        <legend>
	                        	<?php echo esc_html( $package_label ); ?>
	                        </legend>
		                	<select name="ovabrw_package" id="ovabrw_package">
		                		<option value selected="selected">
		                			<?php echo esc_html( $package_placeholder ); ?>
		                		</option>

		                		<?php foreach( $package_items as $package_item) {
		                			if( $package_item['package_type'] === "day" ) {
		                		       	$value = $package_item['package_day_value']*24*60*60;
		                		    } elseif( $package_item['package_type'] === "hour" ) {
		                                $value = $package_item['package_hour_value']*60*60;  
		                            } elseif( $package_item['package_type'] === "fixed" ) {
		                                $value = $package_item['package_start_time'].'|'.$package_item['package_end_time'];
		                            }
		                		?>
			                		<option value="<?php esc_attr_e( $value ) ; ?>">
			                			<?php esc_html_e( $package_item['package_name'] ); ?>
			                		</option>
		                	    <?php }?>
		                	</select>
		                	<i aria-hidden="true" class="icon-left icomoon icomoon-layer"></i>
		                	<i class="icon-right icomoon icomoon-angle-down"></i>
	                    </fieldset>
                    </div>
                </div>

	        <?php endif; ?>

	         <!-- time check in -->
			<div class="search-field">
				<div class="ovabrw-input">
					<fieldset>
                        <legend>
                        	<?php echo esc_html( $check_in_label ); ?>
                        </legend>
						<input 
							type="text" 
							name="ovabrw_pickup_date" 
							class="ovabrw_datetimepicker ovabrw_start_date" 
							placeholder="<?php echo esc_attr( $placeholder ); ?>" 
							autocomplete="off" 
							data-hour_default="<?php echo esc_attr( $hour_default ); ?>" 
							data-time_step="<?php echo esc_attr( $time_step ); ?>" 
							data-dateformat="<?php echo esc_attr( $dateformat ); ?>" 
							onkeydown="return false" 
							onfocus="blur();" 
							data-firstday='<?php echo esc_attr( $first_day ); ?>' 
							timepicker="<?php echo esc_attr( $show_time ); ?>" />
						<i aria-hidden="true" class="icon-left icomoon icomoon-calendar-alt"></i>
						<i class="icon-right icomoon icomoon-angle-down"></i>
					</fieldset>
				</div>
			</div>
            
            <!-- time check out -->
            <?php if( $show_package !== 'yes' ) : ?>
				<div class="search-field">
					<div class="ovabrw-input">
						<fieldset>
	                        <legend>
	                        	<?php echo esc_html( $check_out_label ); ?>
	                        </legend>
							<input 
								type="text" 
								name="ovabrw_pickoff_date" 
								class="ovabrw_datetimepicker ovabrw_end_date" 
								placeholder="<?php echo esc_attr( $placeholder ); ?>" 
								autocomplete="off" 
								data-hour_default="<?php echo esc_attr( $hour_default ); ?>" 
								data-time_step="<?php echo esc_attr( $time_step ); ?>" 
								data-dateformat="<?php echo esc_attr( $dateformat ); ?>" 
								onkeydown="return false" 
								onfocus="blur();" 
								data-firstday='<?php echo esc_attr( $first_day ); ?>' 
								timepicker="<?php echo esc_attr( $show_time ); ?>" />
							<i aria-hidden="true" class="icon-left icomoon icomoon-calendar-alt"></i>
							<i class="icon-right icomoon icomoon-angle-down"></i>
						</fieldset>
					</div>
				</div>
			<?php endif; ?>
		

            <!-- guest -->
			<div class="search-field guestspicker-control">
				<fieldset>
                    <legend>
                    	<?php echo esc_html( $guests_label ); ?>
                    </legend>
                    <div class="ovabrw-guestspicker">
						<div class="guestspicker">
							<span class="gueststotal"><?php esc_html_e( $gueststotal ); ?></span>
							<span class="guestslabel"><?php echo esc_html( $guests_placeholder ); ?></span>
							<i class="icon-right icomoon icomoon-angle-down"></i>
						</div>
					</div>
					<i aria-hidden="true" class="icon-left icomoon icomoon-user-friends"></i>
                </fieldset>

				<div class="ovabrw-guestspicker-content">
					<div class="guests-buttons">
						<div class="description">
							<label><?php echo esc_html( $adults_label ); ?></label>
						</div>
						<div class="guests-button">
							<div class="guests-icon minus">
								<i class="fas fa-minus"></i>
							</div>
							<input 
								type="text" 
								id="ovabrw_adults" 
								name="ovabrw_adults" 
								class="ovabrw_adults" 
								value="<?php esc_attr_e( $default_adult_number ); ?>" 
								min="<?php echo esc_attr( $min_adult ); ?>" 
								max="<?php echo esc_attr( $max_adult ); ?>" />
							<div class="guests-icon plus">
								<i class="fas fa-plus"></i>
							</div>
						</div>
					</div>

					<div class="guests-buttons">
						<div class="description">
							<label><?php echo esc_html( $childrens_label ); ?></label>
						</div>
						<div class="guests-button">
							<div class="guests-icon minus">
								<i class="fas fa-minus"></i>
							</div>
							<input 
								type="text" 
								id="ovabrw_childrens" 
								name="ovabrw_childrens" 
								class="ovabrw_childrens" 
								value="<?php esc_attr_e( $default_children_number ); ?>" 
								min="<?php echo esc_attr( $min_children ); ?>" 
								max="<?php echo esc_attr( $max_children ); ?>" />
							<div class="guests-icon plus">
								<i class="fas fa-plus"></i>
							</div>
						</div>
					</div>
				</div>
			</div>


		</div>
		<!-- button -->
		<div class="ovabrw-search2-btn">
			<?php if ( 'default' == $args['search_result'] ): ?>
				<input type="hidden" name="ovabrw_search_product" value="ovabrw_search_product" />
                <input type="hidden" name="ovabrw_search" value="search_item" />
                <input type="hidden" name="post_type" value="product" />
			<?php endif; ?>
			<button class="ovabrw-btn" type="submit"><?php printf( $button_label ); ?></button>		
		</div>
	</form>
	
</div>