<?php
namespace ovabrw_product_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ovabrw_search_ajax extends Widget_Base {


	public function get_name() {		
		return 'ovabrw_search_ajax';
	}

	public function get_title() {
		return esc_html__( 'Search Ajax', 'ova-brw' );
	}

	public function get_icon() {
		return 'eicon-search';
	}

	public function get_categories() {
		return [ 'ovabrw' ];
	}

	public function get_script_depends() {

		wp_enqueue_script('ovabrw-fancybox', OVABRW_PLUGIN_URI.'assets/libs/fancybox/fancybox.min.js', array('jquery'),null,true);
		wp_enqueue_style('ovabrw-fancybox', OVABRW_PLUGIN_URI.'assets/libs/fancybox/fancybox.css', array(), null);

		/* Select2 */
		wp_enqueue_style('select2', OVABRW_PLUGIN_URI.'assets/libs/select2/select2.min.css', array(), null);
		wp_enqueue_script('select2', OVABRW_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'),null,true);
		
		return [ 'script-elementor' ];
	}

	protected function register_controls() {

		$search_fields = array(
			'' 					=> esc_html__('Select Search', 'ova-brw'),
			'package' 			=> esc_html__('Package', 'ova-brw'),
			'start_date' 		=> esc_html__('Check in', 'ova-brw'),
			'end_date' 			=> esc_html__('Check out', 'ova-brw'),
			'guests' 			=> esc_html__('Guests', 'ova-brw'),
		);
		
		$this->start_controls_section(
			'section_setting',
			[
				'label' => esc_html__( 'Settings', 'ova-brw' ),
			]
		);

		    $this->add_control(
				'show_time',
				[
					'label' => esc_html__('Show Time', 'ova-brw' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-brw' ),
					'label_off' => esc_html__( 'Hide', 'ova-brw' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' 	=> esc_html__( 'Posts Per Page', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::NUMBER,
					'min' 		=> 1,
					'step' 		=> 1,
					'default' 	=> 10,
				]
			);

			$args_query	= [
				'taxonomy' 	=> 'product_cat',
				'orderby' 	=> 'name',
	        	'order'   	=> 'ASC'
			];

			$categories 	= get_categories( $args_query );
			$args_category 	= array();

			if ( $categories && is_array( $categories ) ) {
				foreach ( $categories as $category ) {
					$args_category[$category->term_id] = $category->cat_name;
				}
			}

			$this->add_control(
				'categories',
				[
					'label' 	=> esc_html__( 'Select Category', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT2,
					'multiple' 	=> true,
					'default' 	=> [],
					'options' 	=> $args_category,
				]
			);

			$this->add_control(
				'orderby',
				[
					'label'   => esc_html__( 'Order By', 'ova-brw' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'title' 		=> esc_html__('Title', 'ova-brw'),
						'ID' 			=> esc_html__('ID', 'ova-brw'),
						'name' 			=> esc_html__('Name', 'ova-brw'),
						'date' 			=> esc_html__('Date', 'ova-brw'),
						'modified' 		=> esc_html__('Modified', 'ova-brw'),
						'rand' 			=> esc_html__('Random', 'ova-brw'),
						'menu_order' 	=> esc_html__( 'Menu order', 'ova-brw' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label'   => esc_html__( 'Order', 'ova-brw' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' 	=> esc_html__('Ascending', 'ova-brw'),
						'DESC' 	=> esc_html__('Descending', 'ova-brw'),
					],
				]
			);

			$this->add_control(
				'field_1',
				[
					'label'   	=> esc_html__( 'Field 1', 'ova-brw' ),
					'type'    	=> Controls_Manager::SELECT,
					'default' 	=> 'package',
					'separator' => 'before',
					'options' 	=> $search_fields,
				]
			);

			$this->add_control(
				'field_2',
				[
					'label'   	=> esc_html__( 'Field 2', 'ova-brw' ),
					'type'    	=> Controls_Manager::SELECT,
					'default' 	=> 'start_date',
					'separator' => 'before',
					'options' 	=> $search_fields,
				]
			);

			$this->add_control(
				'field_3',
				[
					'label'   	=> esc_html__( 'Field 3', 'ova-brw' ),
					'type'    	=> Controls_Manager::SELECT,
					'default' 	=> 'guests',
					'separator' => 'before',
					'options' 	=> $search_fields,
				]
			);

			$this->add_control(
				'button_label',
				[
					'label' 	=> esc_html__( 'Check Button Label', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default'   => 'Search',
					'description' 	=> esc_html__( 'use <br> tag html for line breaks', 'ova-brw' ),
				]
			);

			$this->add_control(
				'check_in_label',
				[
					'label' 	=> esc_html__( 'Check in Label', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'Check in', 'ova-brw' ),
				]
			);

			$this->add_control(
				'check_out_label',
				[
					'label' 	=> esc_html__( 'Check out Label', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'Check out', 'ova-brw' ),
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_package',
			[
				'label' => esc_html__( 'Create Package', 'ova-brw' ),
			]
		);

			$this->add_control(
				'package_label',
				[
					'label' 	=> esc_html__( 'Package Label', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'Package', 'ova-brw' ),
					
				]
			);

			$this->add_control(
				'package_placeholder',
				[
					'label' 	=> esc_html__( 'Package Placeholder', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'Select Package', 'ova-brw' ),
					
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'package_type',
				[
					'label' 	=> esc_html__( 'Type', 'ova-brw' ),
					'type' 		=> Controls_Manager::SELECT,
					'default' 	=> 'hour',
					'options' 	=> [
						'day' 	=> esc_html__('Day', 'ova-brw'),
						'hour' 	=> esc_html__('Hour', 'ova-brw'),
						'fixed' => esc_html__('Fixed', 'ova-brw'),
					]
				]
			);

			$repeater->add_control(
				'package_name',
				[
					'label' 	=> esc_html__( 'Name', 'ova-brw' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Morning', 'ova-brw'),
				]
			);

			$repeater->add_control(
				'package_day_value',
				[
					'label' => esc_html__( 'Day Value', 'ova-brw' ),
					'type' 	=> Controls_Manager::NUMBER,
					'min' 	=> 0,
					'default' 	=> 1,
					'condition' => [
						'package_type' => 'day'
					]
				]
			);

			$repeater->add_control(
				'package_hour_value',
				[
					'label' => esc_html__( 'Hour Value', 'ova-brw' ),
					'type' 	=> Controls_Manager::NUMBER,
					'min' 	=> 0,
					'default' 	=> 3,
					'condition' => [
						'package_type' => 'hour'
					]
				]
			);

			$repeater->add_control(
				'package_start_time',
				[
					'label' => esc_html__( 'Start Time', 'ova-brw' ),
					'type' 	=> Controls_Manager::TEXT,
					'default' 		=> '7:00',
					'description' 	=> esc_html__( 'Time format: 24hour (Ex: 7:00)', 'ova-brw' ),
					'condition' 	=> [
						'package_type' => [ 'fixed' ],
					]
				]
			);

			$repeater->add_control(
				'package_end_time',
				[
					'label' => esc_html__( 'End Time', 'ova-brw' ),
					'type' 	=> Controls_Manager::TEXT,
					'default' 		=> '19:00',
					'description' 	=> esc_html__( 'Time format: 24hour (Ex: 19:00)', 'ova-brw' ),
					'condition' 	=> [
						'package_type' => [ 'fixed' ],
					]
				]
			);

			$this->add_control(
				'package_items',
				[
					'label'       => esc_html__( 'Items', 'ova-brw' ),
					'type'        => Controls_Manager::REPEATER,
					'fields'      => $repeater->get_controls(),
					'default' => [
						[
							'package_type' => 'hour',
							'package_title' => esc_html__( 'Morning', 'ova-brw' ),
							'package_day_value' => 1,
							'package_hour_value' => 3,
						],
					],
					'title_field' => '{{{ package_type }}} - {{{ package_name }}}',
				]
			);	

		$this->end_controls_section();

		$this->start_controls_section(
			'section_guests',
			[
				'label' => esc_html__( 'Guests', 'ova-brw' ),
			]
		);

		    $this->add_control(
				'guests_label',
				[
					'label' 	=> esc_html__( 'Label', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'Guests', 'ova-brw' ),
				]
			);

			$this->add_control(
				'guests_placeholder',
				[
					'label' 	=> esc_html__( 'Placeholder', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'Persons', 'ova-brw' ),
				]
			);

			$this->add_control(
				'adults_options',
				[
					'label' => esc_html__( 'Adults Options', 'ova-brw' ),
					'type' 	=> \Elementor\Controls_Manager::HEADING,
				]
			);

			    $this->add_control(
					'adults_label',
					[
						'label' 	=> esc_html__( 'Label', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::TEXT,
						'default' 	=> esc_html__( 'Adults', 'ova-brw' ),
					]
				);

				$this->add_control(
					'default_adults',
					[
						'label' 	=> esc_html__( 'Default Adult', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::NUMBER,
						'min' 		=> 1,
						'step' 		=> 1,
						'default' 	=> 2,
					]
				);

				$this->add_control(
					'max_adults',
					[
						'label' 	=> esc_html__( 'Maximum Adult', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::NUMBER,
						'min' 		=> 1,
						'step' 		=> 1,
						'default' 	=> 10,
					]
				);

				$this->add_control(
					'min_adults',
					[
						'label' 	=> esc_html__( 'Minimum Adult', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::NUMBER,
						'min' 		=> 1,
						'step' 		=> 1,
						'default' 	=> 1,
					]
				);

			$this->add_control(
				'childrens_options',
				[
					'label' 	=> esc_html__( 'Childrens Options', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			    $this->add_control(
					'childrens_label',
					[
						'label' 	=> esc_html__( 'Label', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::TEXT,
						'default' 	=> esc_html__( 'Childrens', 'ova-brw' ),
					]
				);

				$this->add_control(
					'default_childrens',
					[
						'label' 	=> esc_html__( 'Default Childrens', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::NUMBER,
						'min' 		=> 0,
						'step' 		=> 1,
						'default' 	=> 1,
					]
				);

				$this->add_control(
					'max_childrens',
					[
						'label' 	=> esc_html__( 'Maximum Childrens', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::NUMBER,
						'min' 		=> 0,
						'step' 		=> 1,
						'default' 	=> 4,
					]
				);

				$this->add_control(
					'min_childrens',
					[
						'label' 	=> esc_html__( 'Minimum Childrens', 'ova-brw' ),
						'type' 		=> \Elementor\Controls_Manager::NUMBER,
						'min' 		=> 0,
						'step' 		=> 1,
						'default' 	=> 0,
					]
				);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_ovabrw_search_map',
			[
				'label' => __( 'Search Field', 'ova-brw' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
	            'form_search_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'ova-brw' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-search-ajax .wrap-search-ajax .form-search-map' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

			$this->add_control(
				'search_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color', 'ova-brw' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-search-ajax .wrap-search-ajax .form-search-map .wrap-search-fields' => 'background-color: {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'search_box_shadow',
					'label' => esc_html__( 'Box Shadow', 'ova-brw' ),
					'selector' => '{{WRAPPER}} .ova-search-ajax .wrap-search-ajax .form-search-map .wrap-search-fields',
				]
			);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'ovabrw_ft_element_search_ajax', 'single/search_ajax.php' );

		ob_start();
		ovabrw_get_template( $template, $settings );
		echo ob_get_clean();
	}
}