<?php
namespace ovabrw_product_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Core\Schemes\Color;
use Elementor\Core\Schemes\Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ovabrw_product_booking_form extends Widget_Base {


	public function get_name() {		
		return 'ovabrw_product_booking_form';
	}

	public function get_title() {
		return __( 'Product Booking Form', 'ova-brw' );
	}

	public function get_icon() {
		return 'eicon-form-horizontal';
	}

	public function get_categories() {
		return [ 'ovatheme' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_product_id_options',
			[
				'label' => esc_html__( 'Product Option', 'ova-brw' ),
				'tab' 	=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		    $this->add_control(
				'wc_content_warning',
				[
					'type' 	=> Controls_Manager::RAW_HTML,
					'raw' 	=> esc_html__( 'Don\'t Choose Product if you use this element in templates for product detail page.In Elementor Preview ( When empty Product ), this element display an example product tabs of the latest product', 'ova-brw' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);

			$arr_product 	= array( '0' => esc_html__( 'Choose Product', 'ova-brw' ) );
			$products 		= ovabrw_get_products_rental();

			if ( ! empty( $products ) && is_array( $products ) ) {
				foreach( $products as $product_id ) {
					$arr_product[$product_id] = get_the_title( $product_id );
				}
			} else {
				$arr_product[''] = esc_html__( 'There are no rental products', 'ova-brw' );
			}

			$this->add_control(
				'product_id',
				[
					'label' 	=> esc_html__( 'Choose Product', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> '0',
					'options' 	=> $arr_product,
				]
			);

			$this->add_control(
				'show_booking',
				[
					'label' 	=> esc_html__( 'Show Booking', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> 'tab',
					'options' 	=> [
						'tab' 				=> esc_html__( 'Tabs', 'ova-brw' ),
						'booking'         	=> esc_html__( 'Booking Form', 'ova-brw' ),
						'request_booking' 	=> esc_html__( 'Request Booking', 'ova-brw' ),
					],
				]
			);	

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_booking_form_style',
			[
				'label' => __( 'Booking Form', 'ova-brw' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
	            'booking_form_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'ova-brw' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .forms-booking-tab .yachbat-booking' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_responsive_control(
	            'item_border_radius',
	            [
	                'label' 		=> esc_html__( 'Border Radius', 'ova-brw' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .forms-booking-tab' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_control(
				'booking_bgcolor',
				[
					'label'  => __( 'Background Color', 'ova-brw' ),
					'type' 	 => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .forms-booking-tab' => 'background-color: {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

	}

	protected function render() {
		$settings 		= $this->get_settings();
		$product_id 	= $settings['product_id'];
		$show_booking 	= $settings['show_booking'];

		global $product;

		if ( ! $product ) {
			$product = wc_get_product( $product_id );
		}

		if ( ! $product || ! $product->is_type('ovabrw_car_rental') ) { ?>
			<div class="ovabrw_elementor_no_product">
				<span><?php echo $this->get_title(); ?></span>
			</div>
		<?php return;
		}

		if ( $show_booking === 'tab' ): ?>
			<div class="forms-booking-tab">
				<ul class="tabs">
					<li class="item booking active" data-form="ovabrw_booking_form">
						<?php echo esc_html__( 'Booking', 'ova-brw' ); ?>
					</li>
					<li class="item request-booking" data-form="request_booking">
						<?php echo esc_html__( 'Request Booking', 'ova-brw' ); ?>
					</li>
				</ul>
				<?php ovabrw_get_template( 'single/booking-form.php', [ 'id' => $product_id ] ); ?>
				<?php ovabrw_get_template( 'single/request_booking.php', [ 'id' => $product_id ] ); ?>
			</div>
        <?php elseif ( $show_booking === 'booking' ): ?>
        	<div class="forms-booking-tab ovabrw-not-tabs">
				<ul class="tabs">
					<li class="item booking" data-form="ovabrw_booking_form">
						<?php echo esc_html__( 'Booking', 'ova-brw' ); ?>
					</li>
				</ul>
				<?php ovabrw_get_template( 'single/booking-form.php', [ 'id' => $product_id ] ); ?>
			</div>
		<?php else: ?>
			<div class="forms-booking-tab ovabrw-not-tabs">
				<ul class="tabs">
					<li class="item request-booking" data-form="request_booking">
						<?php echo esc_html__( 'Request Booking', 'ova-brw' ); ?>
					</li>
				</ul>
				<?php ovabrw_get_template( 'single/request_booking.php', [ 'id' => $product_id ] ); ?>
			</div>
		<?php endif;
	}
}