<?php if ( !defined( 'ABSPATH' ) ) exit();

	$id = get_the_id();

	$avatar       = get_post_meta( $id, 'ova_team_met_avatar', true );
	$job          = get_post_meta( $id, 'ova_team_met_job', true );
	$short_desc   = get_post_meta( $id, 'ova_team_met_short_desc', true );
	$list_social  = get_post_meta( $id, 'ova_team_met_group_icon', true );

	$show_short_desc = isset( $args['show_short_desc'] ) ? $args['show_short_desc'] : 'yes' ;
	$show_name       = isset( $args['show_name'] ) ? $args['show_name'] : 'yes' ;
	$show_job        = isset( $args['show_job'] ) ? $args['show_job'] : 'yes' ;
	$show_social     = isset( $args['show_social'] ) ? $args['show_social'] : 'yes' ;
	$show_link_to    = isset( $args['show_link_to_detail'] ) ? $args['show_link_to_detail'] : 'yes' ;

?>

<div class="item-team">

	<div class="img">
		
		<!-- Avata -->
		<?php if( $show_link_to == 'yes' ): ?>
	    <a href="<?php the_permalink(); ?>" >
	    <?php endif; ?>	
	    	<img src="<?php echo esc_url( $avatar ) ?>" class="img-responsive team-img" alt="<?php the_title() ?>">
			<div class="mask"></div>
	    <?php if( $show_link_to == 'yes' ): ?>
		</a>
		<?php endif; ?>	
		
		<!-- List Icon -->
		<?php if( !empty( $list_social ) && $show_social == 'yes' ) : ?>
			<ul class="list-icon"> 
				<?php
					foreach( $list_social as $social ){

						$class_icon = isset( $social['ova_team_met_class_icon_social'] ) ? $social['ova_team_met_class_icon_social'] : '';
						$link_social = isset( $social['ova_team_met_link_social'] ) ? $social['ova_team_met_link_social'] : '';
						?>
						<li class="item">
							<a href="<?php echo esc_url( $link_social ); ?>" title="<?php echo esc_url( $link_social ); ?>" target="_blank">
								<i class="<?php echo esc_attr( $class_icon ) ?>"></i>
							</a>
						</li>
				<?php } ?>
				
			</ul>	
		<?php endif; ?>

		<!-- Short Description -->
		<?php if( !empty( $short_desc ) && $show_short_desc == 'yes' ) : ?>
			<p  class="short-desc">
				<?php echo wp_trim_words( $short_desc, 18, '.') ; ?>
			</p>	
		<?php endif; ?>

	</div>

	<!-- Info -->
	<div class="info">

		<?php if( $show_link_to == 'yes' ): ?>
	    <a href="<?php the_permalink(); ?>" >
	    <?php endif; ?>	

			<?php if( $show_name == 'yes' ) : ?>
				<h3 class="name">
					<?php the_title(); ?>
				</h3>
			<?php endif; ?>
		
		<?php if( $show_link_to == 'yes' ): ?>
		</a>
		<?php endif; ?>	
		
		<?php if ( !empty($job) && $show_job == 'yes') : ?>
			<p  class="job">
				<?php echo esc_html($job) ; ?>
			</p>
		<?php endif; ?>

	</div>
	
</div>