<?php
if ( ! defined( 'ABSPATH' ) ) exit();

global $post;

$id 		         = get_the_id();
$product 	         = wc_get_product( $id );
$short_description	 = apply_filters( 'woocommerce_short_description', $post->post_excerpt );
$gallery_ids	     = $product->get_gallery_image_ids();
$number_gallery      = count( $gallery_ids );

$gallery_src = array();

foreach( $gallery_ids as $k => $gallery_id ) {
	$gallery_url = wp_get_attachment_url( $gallery_id );
	$gallery_alt = get_post_meta( $gallery_id, '_wp_attachment_image_alt', true );

	if ( ! $gallery_alt ) {
		$gallery_alt = get_the_title( $gallery_id );
	}

	$src = array(
		'src' => $gallery_url,
		'caption' => $gallery_alt,
		'thumb' => $gallery_url,
	);

    array_push( $gallery_src, $src );
}

$title 		= get_the_title();
$check_in 	= isset( $args['start_date'] ) ? $args['start_date'] : '';
$check_out 	= isset( $args['end_date'] ) ? $args['end_date'] : '';
$adults 	= isset( $args['adults'] ) ? $args['adults'] : 1;
$childrens 	= isset( $args['childrens'] ) ? $args['childrens'] : 0;

$date_format = ovabrw_get_date_format();
$time_format = ovabrw_get_time_format_php();

$rental_type = get_post_meta( $id, 'ovabrw_price_type', true );
$defined_one_day = defined_one_day( $id );

$date_time_format = $date_format . ' ' . $time_format;
if ( $rental_type == 'period_time' || $defined_one_day ==  'hotel' ) {
	$date_time_format = $date_format;
}

$package_time = isset( $args['package_time'] ) ? sanitize_text_field( $args['package_time'] ) : '';
$new_time = get_date_from_package( $package_time, $check_in );
if ( $new_time['pickup_date'] ) {
	$check_in = date( $date_time_format, $new_time['pickup_date'] );
}
if ( $new_time['pickoff_date'] ) {
	$check_out = date( $date_time_format, $new_time['pickoff_date'] );
}

if ( $check_in ) {
	$check_in 	= date( $date_time_format, strtotime( $check_in ) );
}
if ( $check_out ) {
	$check_out 	= date( $date_time_format, strtotime( $check_out ) );
}

$link = add_query_arg( array(
	    'pickup_date' 		=> $check_in,
	    'dropoff_date' 		=> $check_out,
	    'ovabrw_adults' 	=> $adults,
	    'ovabrw_childrens' 	=> $childrens
	), get_permalink( $id ) );

$image_url 	= get_the_post_thumbnail_url( $id, 'single-post-thumbnail' );
$image_id 	= get_post_thumbnail_id();
$image_alt 	= '';

if ( $image_id ) {
	$image_alt 		= get_post_meta( $image_id, '_wp_attachment_image_alt', true );
	if ( empty( $image_alt ) ) {
		$image_alt = get_the_title( $image_id );
	}
}

$video_link        = get_post_meta( $id, 'ovabrw_video_link', true );
$price             = get_post_meta( $id, '_regular_price', true );
$children_number   = get_post_meta( $id, 'ovabrw_children_number', true );
$adult_number      = get_post_meta( $id, 'ovabrw_adult_number', true );
$people            = $children_number + $adult_number;
$star              = get_post_meta( $id, 'ovabrw_star_level', true );
$year              = get_post_meta( $id, 'ovabrw_year', true );
$feet              = get_post_meta( $id, 'ovabrw_feet', true );

?>

<div class="ovabrw-yacht-content2">

	<div class="wrapper-yacht">
		
		<div class="yacht-img">  
			<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">

			<div class="yacht-video-gallery-wrapper">
				<div class="yacht-video-gallery yacht-video-link" data-src="<?php echo esc_attr( $video_link ); ?>">
					<i aria-hidden="true" class="icomoon icomoon-caret-circle-right"></i>
					<span class="text">
						<?php echo esc_html__('View video','ova-brw'); ?>
					</span>
				</div>

				<div class="yacht-video-gallery yacht-image-gallery fancybox" data-gallery-src="<?php echo esc_attr( json_encode( $gallery_src ) );?>">
					<i aria-hidden="true" class="icomoon icomoon-photo"></i>
					<span class="text">
						<?php echo esc_html( $number_gallery ) . ' ' . esc_html__('Photo','ova-brw'); ?>
					</span>
				</div>
	        </div>
		</div>

		<div class="yacht-container">

			<h2 class="yacht-title">
				<?php echo esc_html( $title ); ?>
			</h2>

			<?php wc_get_template( 'rental/review.php' ); ?>

			<ul class="yacht-service">
				<?php if( !empty($star) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-badge"></i>
						<span>
						    <?php echo esc_html( $star ) . ' ' . esc_html__('Star','ova-brw');?>	
						</span>
					</li>
				<?php endif; ?>
				<?php if( !empty($people) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-users"></i>
						<span>
						    <?php echo esc_html( $people ) . ' ' . esc_html__('People','ova-brw');?>	
						</span>
					</li>
				<?php endif; ?>
				<?php if( !empty($year) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-tools"></i>
						<span> 
							<?php echo esc_html( $year ); ?>	
						</span>
					</li>
				<?php endif; ?>
				<?php if( !empty($feet) ) : ?>
					<li class="square">
						<i aria-hidden="true" class="icomoon icomoon-ruler-combined"></i>
						<span> 
							<?php echo esc_html( $feet );?>
						</span>
					</li>
				<?php endif; ?>
			</ul>

			<div class="yacht-short-description">
				<?php echo $short_description; ?>
			</div>

			<div class="yacht-container-footer">
				<?php wc_get_template( 'rental/price.php' ); ?>

				<div class="yacht-button-wrapper">
					<div class="yacht-button-view-deals" data-yacht-id="<?php echo esc_attr( $id ); ?>">
						<a href="<?php echo esc_url( $link ); ?>">
							<?php echo esc_html__( 'View Details', 'ova-brw' ); ?>
							<i aria-hidden="true" class="icomoon icomoon-long-arrow-right"></i>
						</a>
					</div>

					<div class="yacht-button" data-yacht-id="<?php echo esc_attr( $id ); ?>">
						<?php echo esc_html__( 'Book Now', 'ova-brw' ); ?>
						<i aria-hidden="true" class="icomoon icomoon-long-arrow-right"></i>
					</div>
			    </div>

			</div>

		</div>
	</div>

	<div class="yacht-load-more" style="display: none;">
		<svg class="loader" width="50" height="50">
			<circle cx="25" cy="25" r="10" />
			<circle cx="25" cy="25" r="20" />
		</svg>
	</div>
	<div class="booking-yacht"></div>
</div>