<?php
/**
 * Setup yachbat Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 **/

add_action('rest_api_init', function () {
    register_rest_route('getyourguide', '2/get-availabilities', array(
        'methods' => 'GET',
        'callback' => 'get_availabilities'
    ));

    register_rest_route('getyourguide', '2/reserve', array(
        'methods' => 'POST',
        'callback' => 'reserve_booking'
    ));

    register_rest_route('getyourguide', '2/book', array(
        'methods' => 'POST',
        'callback' => 'book_charter'
    ));

    register_rest_route('getyourguide', '2/cancel-reservation', array(
        'methods' => 'POST',
        'callback' => 'cancel_reservation'
    ));

    register_rest_route('getyourguide', '2/cancel-booking', array(
        'methods' => 'POST',
        'callback' => 'cancel_booking'
    ));
});

function get_availabilities($request) {

/** Instead of the given $availabilities object, fetch all available products from our database and construct the data in the sample format below. This will be consumed by GetYourGuide for checking available slots in a specified time interval. **/

    $availabilities = array(
        'availabilities' => array(
            array(
                'dateTime' => '2024-06-01T10:00:00+02:00',
                'openingTimes' => array(
                    array('fromTime' => '10:00', 'toTime' => '18:00')
                ),
                'productId' => '5334',
                'cutoffSeconds' => 0,
                'vacancies' => 10
            ),
            array(
                'dateTime' => '2024-06-01T10:00:00+02:00',
                'openingTimes' => array(
                    array('fromTime' => '10:00', 'toTime' => '21:00')
                ),
                'productId' => '7029',
                'cutoffSeconds' => 0,
                'vacancies' => 12
            )
        )
    );

    return new WP_REST_Response(array('data' => $availabilities), 200);
    /* Handle other errors using if else conditions */
}

 function reserve_booking($request) {
    $request_data = array(
        'data' => array(
            'reserveItems' => array(
                array('category' => 'GROUP', 'count' => 1, 'groupSize' => 2),
                array('category' => 'GROUP', 'count' => 1, 'groupSize' => 3)
            ),
            'dateTime' => '2024-06-01T10:00:00+02:00',
            'productId' => '5334',
            'gygBookingReference' => 'GYG189H3K1'
        )
    );

    if (empty($request_data['data']['reserveItems']) || empty($request_data['data']['dateTime']) || empty($request_data['data']['productId']) || empty($request_data['data']['gygBookingReference'])) {
        return new WP_REST_Response(array('error' => 'Invalid request data'), 400);
    }

    $response_data = array(
        'data' => array(
            'reservationReference' => 'res789',
            'reservationExpiration' => '2024-06-05T07:35:53+00:00'
        )
    );

    return new WP_REST_Response($response_data, 200);
}

function cancel_reservation($request) {
    $request_data = array(
        "data" => array(
            "reservationReference" => "res789",
            "gygBookingReference" => "GYG189H3K1"
        )
    );
    


    if (empty($request_data['data']['reservationReference']) || empty($request_data['data']['gygBookingReference']))
    {
        return new WP_REST_Response(array('error' => 'Invalid request data'), 400);
    }
    else
    {
      /* Here fetch the corresponding resevation from our db using reference id, then update the status back to "AVAILABLE" */
       $response_data = array(
        "data" => array()
       );
       return new WP_REST_Response($response_data, 200);
    }    

}

function book_charter($request) {
    $request_data = array(
        'data' => array(
            'bookingItems' => array(
                array('category' => 'GROUP', 'count' => 1, 'groupSize' => 2, 'retailPrice' => 1560),
                array('category' => 'GROUP', 'count' => 1, 'groupSize' => 3, 'retailPrice' => 1800)
            ),
            'dateTime' => '2024-06-02T10:00:00+02:00',
            'currency' => 'EUR',
            'gygBookingReference' => 'GYG189H3K1',
            'productId' => '5334',
            'reservationReference' => 'res789',
            'travelers' => array(
                array(
                    'email' => 'john@john-smith.com',
                    'firstName' => 'John',
                    'lastName' => 'Smith',
                    'phoneNumber' => '+49 030 1231231'
                )
            )
        )
    );

    if (empty($request_data['data']['bookingItems']) || empty($request_data['data']['dateTime']) || empty($request_data['data']['currency']) || empty($request_data['data']['gygBookingReference']) || empty($request_data['data']['productId']) || empty($request_data['data']['reservationReference']) || empty($request_data['data']['travelers']) )
    {
        return new WP_REST_Response(array('error' => 'Invalid request data'), 400);
    }

    $response_data = array(
        'data' => array(
            'bookingReference' => 'GYGBK01062024',
            'tickets' => array(
                array(
                    'category' => 'GROUP',
                    'ticketCode' => 'code001',
                    'ticketCodeType' => 'QR_CODE'
                ),
                array(
                    'category' => 'GROUP',
                    'ticketCode' => 'code002',
                    'ticketCodeType' => 'QR_CODE'
                )
            )
        )
    );

    return new WP_REST_Response($response_data, 200);

}

function cancel_booking($request) {
    $request_data = array(
        "data" => array(
            "bookingReference" => "bk456",
            "gygBookingReference" => "GYG1B2D34GHI",
            "productId"=>"5334"
        )
    );
    
    if (empty($request_data['data']['bookingReference']) || empty($request_data['data']['gygBookingReference'])|| empty($request_data['data']['productId']))
    {
        return new WP_REST_Response(array('error' => 'Invalid request data'), 400);
    }
    else
    {
      /* Here fetch the corresponding resevation from our db using reference id, then update the status back to "AVAILABLE" */
       $response_data = array(
        "data" => array()
       );
       return new WP_REST_Response($response_data, 200);
    }    

}

?>