<?php
/**
 * Setup yachbat Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 */

require_once (get_stylesheet_directory().'/functions_secondary.php');
 //require_once (get_stylesheet_directory().'/getyourguide.php');
 require_once (get_stylesheet_directory().'/getyourguide_func.php');



function yachbat_child_theme_setup() {
	load_child_theme_textdomain( 'yachbat-child', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'yachbat_child_theme_setup' );



function yachbat_enqueue_styles() {
    $parenthandle = 'yachbat-style'; // This is 'twentyfifteen-style' for the Twenty Fifteen theme.
    $theme = wp_get_theme();
    wp_enqueue_style( $parenthandle, get_template_directory_uri() . '/style.css', 
        array(),  // if the parent theme code has a dependency, copy it to here
        $theme->parent()->get('Version')
    );
    wp_enqueue_style( 'child-style', get_stylesheet_uri(),
        array( $parenthandle ),
        $theme->get('Version') // this only works if you have Version in the style header
    );
}
add_action( 'wp_enqueue_scripts', 'yachbat_enqueue_styles' );

function my_theme_scripts() {
    wp_enqueue_script( 'custom_script', get_stylesheet_directory_uri(). '/assets/js/custom_script.js', array( 'jquery' ), '1.0.0', true );
}
add_action( 'login_enqueue_scripts', 'my_theme_scripts' );

function boat_scripts()
{
    wp_enqueue_style( 'frontend_css', get_stylesheet_directory_uri() . '/assets/css/frontend.css', false, '1.0' );
    wp_enqueue_script('frontend_js', get_stylesheet_directory_uri() . '/assets/js/custom_frontend.js', array('jquery'), '1.0');
    wp_localize_script( 'frontend_js', 'ajax_param', array('url' => admin_url('admin-ajax.php')) );
    wp_enqueue_script( 'wc-add-to-cart2', get_bloginfo( 'stylesheet_directory' ). '/assets/js/billing-address-frontend.js' , array( 'jquery' ), false, true );
}
add_action('wp_footer', 'boat_scripts');



function my_ajax_action_callback(){
    $items_count = WC()->cart->get_cart_contents_count(); 
   echo $items_count ;

    wp_die(); // required to end AJAX request.

}
add_action( 'wp_ajax_my_ajax_action', 'my_ajax_action_callback' );
add_action( 'wp_ajax_nopriv_my_ajax_action', 'my_ajax_action_callback' );

/*
function auto_redirect_after_logout(){
    //wp_redirect( home_url()."/login", 301 );
    exit();
    }
add_action('wp_logout','auto_redirect_after_logout');
*/
function store_user_role_on_login($user_login, $user) {
    // Store the user's role in a session variable
    $roles = $user->roles;
    if (!session_id()) {
        session_start();
    }
    $_SESSION['user_role'] = $roles[0]; // Assuming a user has at least one role
}
add_action('wp_login', 'store_user_role_on_login', 10, 2);
function auto_redirect_after_logout() {
    if (!session_id()) {
        session_start();
    }
    if (isset($_SESSION['user_role'])) {
        $role = $_SESSION['user_role'];
       // print_r($role); exit;
        $redirect_url = home_url('/login'); // Default redirect URL

        if ($role === 'subscriber'|| $role === 'affiliate') {
            $redirect_url = home_url('/login');
        }else{
            $redirect_url = home_url('/wp-admin');
        }

        // Clear the session variable
        unset($_SESSION['user_role']);

        wp_redirect($redirect_url);
        exit;
    }
}

add_action('wp_logout', 'auto_redirect_after_logout');

  function my_text_strings( $translated_text, $text, $domain ) {
    if($domain == 'woocommerce' && $translated_text ==  'Order summary'){
        $translated_text = __( 'Package1', 'wpforms-lite' ); 
    }
	switch ( $translated_text ) {
		case 'Orders' :
			$translated_text = __( 'Bookings', 'woocommerce' );
			break;
        case 'Order' :
            $translated_text = __( 'Booking', 'woocommerce' );
            break;  
        case 'Package' :
            $translated_text = __("Time slot","woocommerce");
            break; 
            case 'Thank you. Your order has been received.' :
            $translated_text = __("Thank you. Your booking has been received.","woocommerce");
            break;
            case 'Order details' :
            $translated_text = __("Booking Details","woocommerce");
            break; 
            case 'Order number:' :
            $translated_text = __("Booking number:","woocommerce");
            break; 
            case 'Billing address' :
            $translated_text = __("Contact address","woocommerce");
            break;                        
            case 'Book Now' :
                if(is_page('charter')){
                    $translated_text = __("View Details","yachbat"); 
                }
                break; 
            case 'Per item' :
                $translated_text = __("Per Charter","yachbat");
                break;     
                case 'Yacht' :
                    $translated_text = __("Charter","ova-brw");
                    break; 
                case 'Order Status' :
                    $translated_text = __("Booking Status","ova-brw");
                    break;  
                case 'Manage Order' :
                    $translated_text = __("Manage Booking","ova-brw");
                    break; 
                case 'Check-in - Check-out' :
                    $translated_text = __("Time Slot","ova-brw");
                    break;  
                case 'Products' :
                    $translated_text = __("Charters","ova-brw");
                    break;  
                case 'WooCommerce Status' :
                       $translated_text = __("Booking Status","ova-brw");
                        break; 
                case 'Orders' :
                            $translated_text = __( 'Bookings', 'ova-brw' );
                            break;
                case 'Jetpack Stats' :
                        $translated_text = __( 'Website Traffic Overview', 'ova-brw' );
                        break;
                case 'Name Product' :
                    $translated_text = __( 'Name Charter', 'ova-brw' );
                    break;  
                case 'Product' :
                    $translated_text = __( 'Charter', 'ova-brw' );
                    break; 
                case 'Select Yacht' :
                    $translated_text = __( 'Select  Charters', 'ova-brw' );
                    break;
                case 'Create Order' :
                    $translated_text = __( 'Block Booking Slot', 'ova-brw' );
                    break;                  
                        
    

	}
	return $translated_text;
}
add_filter( 'gettext', 'my_text_strings', 20, 3 );


function unset_specific_order_item_meta_data($formatted_meta, $item){
    /*
    // Only on emails notifications
    if(is_admin() || is_wc_endpoint_url()) {
        return $formatted_meta;
    }
    */

    foreach($formatted_meta as $key => $meta){
        if(in_array($meta->key, array('ovabrw_adults','ovabrw_childrens','ovabrw_number_vehicle','ovabrw_pickoff_date'))) {
            unset($formatted_meta[$key]);
        }
    }
    return $formatted_meta;
}
add_filter('woocommerce_order_item_get_formatted_meta_data', 'unset_specific_order_item_meta_data', 10, 2);








remove_action( 'wp_ajax_ovabrw_search_ajax_validation_booking_form', 'ovabrw_search_ajax_validation_booking_form' );
remove_action( 'wp_ajax_nopriv_ovabrw_search_ajax_validation_booking_form', 'ovabrw_search_ajax_validation_booking_form' );

add_action( 'wp_ajax_ovabrw_search_ajax_validation_booking_form', 'ovabrw_search_ajax_validation_booking_form_custom' );
add_action( 'wp_ajax_nopriv_ovabrw_search_ajax_validation_booking_form', 'ovabrw_search_ajax_validation_booking_form_custom' );
function ovabrw_search_ajax_validation_booking_form_custom() {
	$data 			= $_POST;
	$yacht_id 		= isset( $data['yacht_id'] )  	? (int)( $data['yacht_id'] ) 				  : '';
	$check_in 		= isset( $data['check_in'] )  	? strtotime( $data['check_in'] ) 			  : '';
    $check_out 		= isset( $data['check_out'] ) 	? strtotime( $data['check_out'] ) 			  : '';
    $pickup_loc 	= isset( $data['pickup_loc'] ) 	? sanitize_text_field( $data['pickup_loc'] )  : '';
    $pickoff_loc 	= isset( $data['pickoff_loc'] ) ? sanitize_text_field( $data['pickoff_loc'] ) : '';
    $adults 		= isset( $data['adults'] ) 		? (int)$data['adults']						  : '';
    $childrens 		= isset( $data['childrens'] ) 	? (int)$data['childrens']					  : '';
    $yachts 		= isset( $data['yachts'] ) 		? (int)$data['yachts']						  : 1;
    $services 		= isset( $data['services']) 	? str_replace( '\\', '', $data['services'] )  : '';
    $package_id 	= isset( $data['package_id'] )  ? sanitize_text_field( $data['package_id'] ) : '';

    $services 		= (array) json_decode( $services );

    // Retal type
    $rental_type 	= get_post_meta( $yacht_id, 'ovabrw_price_type', true );

    // Max adults, childrens
    $max_adults     = (int)get_post_meta( $yacht_id, 'ovabrw_adult_number', true );
    $max_childrens  = (int)get_post_meta( $yacht_id, 'ovabrw_children_number', true );

    // Rent day min
    $day_min 		= (int)get_post_meta( $yacht_id, 'ovabrw_rent_day_min', true );

    // Rent hour min
    $hour_min 		= (int)get_post_meta( $yacht_id, 'ovabrw_rent_hour_min', true );

    $new_date 		= ovabrw_new_input_date( $yacht_id, $check_in, $check_out, $package_id, $pickup_loc, $pickoff_loc );
    $check_in_new 	= $new_date['pickup_date_new'];
    $check_out_new 	= $new_date['pickoff_date_new'];

    $data = array();

    $service_required = get_post_meta( $yacht_id, 'ovabrw_service_required', true );

    if ( $service_required ) {
        foreach ($service_required as $key => $value) {
            if( $value == 'yes' ){
                if ( ! ( isset( $services[$key] ) && $services[$key] ) ) {
                    $data = array(
			    		'error' 	=> true,
			    		'message' 	=> esc_html( "Please choose Extra Service", 'ova-brw' )
			    	);
                    break;
                }
            }
        }
    }

    if ( $yachts < 1 ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Please choose yachts greater 0", 'ova-brw' )
    	);
    } else if ( $adults < 1 ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Please choose the number of adults greater 0", 'ova-brw' )
    	);
    } else if ( $adults > $max_adults ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> sprintf( esc_html__( 'Please choose the number of adults less than %d', 'ova-brw' ), $max_adults )
    	);
    } else if ( $childrens > $max_childrens ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> sprintf( esc_html__( 'Please choose the number of childrens less than %d', 'ova-brw' ), $max_childrens )
    	);
    } else if ( empty( $check_in_new ) || empty( $check_out_new ) ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Please insert Check in, Check out date", 'ova-brw' )
    	);
    } else if ( $check_in_new < current_time('timestamp') ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Check in must be greater than Current Time", 'ova-brw' )
    	);
    } else if ( $check_in_new >  $check_out_new ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Check out must be greater than Check in", 'ova-brw' )
    	);
    } else {
    	$data = array(
    		'error' 	=> false
    	);
    }

    switch( $rental_type ) {
        case 'day':
	        if ( ovabrw_val_day_min( $check_out_new, $check_in_new, $day_min ) ){
	            $data = array(
		    		'error' 	=> true,
		    		'message' 	=> sprintf( esc_html__( 'Min Rental Period: %d day', 'ova-brw' ), $day_min )
		    	);
	        }
	        break;
        case 'hour':
	        if ( ovabrw_val_hour_min( $check_out_new, $check_in_new, $hour_min ) ) {
	        	$data = array(
		    		'error' 	=> true,
		    		'message' 	=> sprintf( esc_html__( 'Min Rental Hours %d hour', 'ova-brw' ), $hour_min )
		    	);
	        }
        	break;
        case 'mixed':
	        if ( ovabrw_val_hour_min( $check_out_new, $check_in_new, $hour_min ) ){
	        	$data = array(
		    		'error' 	=> true,
		    		'message' 	=> sprintf( esc_html__( 'Min Rental Hours %d hour', 'ova-brw' ), $hour_min )
		    	);
	        }
	        break;
    }

    $untime_startdate = get_post_meta( $yacht_id, 'ovabrw_untime_startdate', true );
    $untime_enddate   = get_post_meta( $yacht_id, 'ovabrw_untime_enddate', true );

    if ( $untime_startdate ) {
        foreach ( $untime_startdate as $key => $value ) {
            if ( ! ( $check_out_new < strtotime( $untime_startdate[$key] ) || strtotime( $untime_enddate[$key] ) < $check_in_new ) ) {
            	$data = array(
		    		'error' 	=> true,
		    		'message' 	=> esc_html__( 'This time is not available for renting', 'ova-brw' )
		    	);
            }
        }
    }

    $disable_week_day      = get_option( 'ova_brw_calendar_disable_week_day', '' );
    $data_disable_week_day = $disable_week_day != '' ? explode( ',', $disable_week_day ) : '';

    if ( $data_disable_week_day && $check_in_new && $check_out_new ) {
        $datediff       = (int)$check_out_new - (int)$check_in_new;
        $total_datediff = round( $datediff / (60 * 60 * 24), wc_get_price_decimals() ) + 1;

        // get number day
        $pickup_date_of_week   = date('w', $check_in_new );
        $pickup_date_timestamp = $check_in_new;
        
        $i = 0;

        while ( $i <= $total_datediff ) {
            if ( in_array( $pickup_date_of_week, $data_disable_week_day ) ) {
                $data = array(
		    		'error' 	=> true,
		    		'message' 	=> esc_html__( 'This time is not available for renting', 'ova-brw' )
		    	);
            }

            $pickup_date_of_week  = date('w', $pickup_date_timestamp );
            
            $pickup_date_timestamp = strtotime('+1 day', $pickup_date_timestamp);

            $i++;
        }
    }

    $manage_store = get_post_meta( $yacht_id, 'ovabrw_manage_store', true );

    // Check Count Product in Order
    $in_store = ovabrw_vehicle_rented_in_order( $yacht_id, $check_in_new, $check_out_new );
    
    // Check Count Product in Cart
    $in_cart  = ovabrw_vehicle_rented_in_cart( $yacht_id, 'cart', $check_in_new, $check_out_new );

    $total_car_store = (int)get_post_meta( $yacht_id, 'ovabrw_car_count', true );

    $yachts_available = $total_car_store - $in_store - $in_cart;

    if ( $yachts_available < $yachts ) {
        $data = array(
    		'error' 	=> true,
    		'message' 	=> sprintf( esc_html__( 'Available yachts is %s', 'ova-brw'  ), $yachts_available )
    	);
    }

    if ( $yachts_available < 0 || $yachts_available == 0 ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html__( 'Yachts isn\'t available for this time, Please book other time.', 'ova-brw' )
    	);
    }

    $statuses   = brw_list_order_status();
    $orders_ids = ovabrw_get_orders_by_product_id( $yacht_id, $statuses );
    if( $orders_ids ) {
        foreach ($orders_ids as $key => $value) {

            // Get Order Detail by Order ID
            $order = wc_get_order($value);
            $order_line_items = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
                
            // For Meta Data
            foreach ( $order_line_items as $item_id => $item ) {
                $pickup_date_each = wc_get_order_item_meta( $item_id, 'ovabrw_pickup_date', true );
                if($check_in_new == strtotime($pickup_date_each)){
                    $data = array(
                        'error' 	=> true,
                        'message' 	=> esc_html__("This date is already picked. Please choose another date" , 'ova-brw'  )
                    );
                }
            }
        }
    }
    //$new = print_r($data,true);
	

    echo json_encode( $data );

	wp_die();
}



/**
 * Renders a notice and prevents checkout if the cart
 * only contains products in a specific category
 */
function sv_wc_prevent_checkout_for_category() {

    $statuses   = brw_list_order_status();
    
    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {

       
        if($yatch_id = $cart_item['data']->id){
            $yatch = $cart_item['data'];
            
            $orders_ids = ovabrw_get_orders_by_product_id( $yatch_id, $statuses ); 
           
            foreach ($orders_ids as $key => $value) {
                $order = wc_get_order($value);
                $order_line_items = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );

                foreach ( $order_line_items as $item_id => $item ) {

                    if($item['product_id'] == $yatch_id){

                   
                    $pickup_date_each = wc_get_order_item_meta( $item_id, 'ovabrw_pickup_date', true );
                    $pickup_date[]= $pickup_date_each;
                        if($cart_item['ovabrw_pickup_date'] == $pickup_date_each){
                            wc_add_notice( esc_html__( 'The charter has been <b>'.$item['name'].'</b> already booked on this time slot. Please remove this from your cart to proceed.', 'ova-brw'), 'error' );
                            if ( is_cart() || is_checkout() ) {
                                $style = "
                                <style>
                                    .wc-block-cart__submit-button{
                                        display: none!important;
                                    }
                                    .wc-block-components-checkout-place-order-button{
                                        display: none!important;
                                    } 
                                </style>
                            ";
                            echo $style;
                            }
                        }
                    }
                        
                }
               
            }           
        }
        
    }

}
add_action( 'woocommerce_check_cart_items', 'sv_wc_prevent_checkout_for_category' );





function my_login_script() { 
    wp_enqueue_style( 'admin_login_css', get_stylesheet_directory_uri() . '/assets/css/admin_login.css', array(),  '1.0' );
    wp_enqueue_script( 'admin_login_js', get_stylesheet_directory_uri(). '/assets/js/admin_login.js', array( 'jquery' ), '1.0.0', true );
    ?>


    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(https://a1boat.test4u.in/wp-content/uploads/2022/04/a1-boat-charters-logo-home.png);
            height:auto;
            width:125px;
            background-size: 127px auto;
            background-repeat: no-repeat;
            padding-bottom: 63px;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_script' );



function my_admin_script() {
    wp_enqueue_style( 'admin_custom_css', get_stylesheet_directory_uri() . '/assets/css/admin_custom.css', false, '1.0' );
    wp_enqueue_script( 'admin_custom_js', get_stylesheet_directory_uri(). '/assets/js/admin_custom.js', array( 'jquery' ), '1.0', true );
    wp_localize_script( 'admin_custom_js', 'ajax_param', array('url' => admin_url('admin-ajax.php')) );
}
add_action( 'admin_enqueue_scripts', 'my_admin_script' );

function your_theme_prefix_continue_shopping_redirect_url($url) {
$url = home_url('/charter');
return $url;
}
add_filter('woocommerce_return_to_shop_redirect', 'your_theme_prefix_continue_shopping_redirect_url');

// Displaying a message on cart page for non logged users (Optional)
add_action( 'template_redirect', 'wc_redirect_non_logged_to_login_access');
function wc_redirect_non_logged_to_login_access() {

    if ( !is_user_logged_in() && ( is_checkout() ) ) {
        wp_redirect( home_url('login') );
        exit();
    }
}


add_filter( 'woocommerce_billing_fields', 'njengah_make_phone_number_required', 10, 1 );

function njengah_make_phone_number_required( $address_fields ) {
$address_fields['billing_phone']['required'] = true;
return $address_fields;
}


/*WOOCOMMERCE UNSET REQUIRED FIELD IN EDIT ACCOUNT*/

add_filter( 'woocommerce_save_account_details_required_fields', 'misha_myaccount_required_fields' );
function misha_myaccount_required_fields( $account_fields ) {
	unset( $account_fields[ 'account_last_name' ] );

	return $account_fields;
		
}

function my_custom_checkout_fields( $fields ) {

    $fields['billing']['billing_phone'] = array(
    'label' => __('Phone Number', 'woocommerce'),
    'placeholder' => _x('Phone Number', 'placeholder', 'woocommerce'),
    'required' => true,
    'class' => array('form-row-wide'),
    // Add these class names to the field's input tag class attribute (You can change them as per your requirement) These classes will be applied after WooCommerce default classes (which are mentioned above) +
    );
    return $fields;
    }
add_filter( 'woocommerce_checkout_fields' , 'my_custom_checkout_fields' ); // Hook in

add_filter( 'woocommerce_billing_fields', 'wc_unrequire_wc_phone_field');
function wc_unrequire_wc_phone_field( $fields ) {
$fields['billing_phone']['required'] = true;
return $fields;
}

add_action('woocommerce_checkout_process', 'custom_validate_billing_phone');
function custom_validate_billing_phone() {

    if (!isset( $_POST['billing_phone'] )) {
        wc_add_notice( __( 'The Phone field is<strong>required</strong>.' ), 'error' );
    }
}

add_filter( 'woocommerce_checkout_fields' , 'custom_checkout_fields1' );
function custom_checkout_fields1( $fields ) {
    $fields['billing']['billing_phone']['custom_attributes']['readonly'] = 'readonly';

    return $fields;
}


add_filter( 'woocommerce_registration_redirect', 'bbloomer_customer_register_redirect' );
 
function bbloomer_customer_register_redirect( $redirect_url ) {
   $redirect_url = '/checkout';  
   return $redirect_url;
}

add_filter( 'woocommerce_registration_redirect', 'custom_redirection_after_registration', 10, 1 );
function custom_redirection_after_registration( $redirection_url ){
    // Change the redirection Url
    $redirection_url = '/checkout';// Home page

    return $redirection_url; // Always return something
}

add_action( 'woocommerce_payment_complete', 'order_received_empty_cart_action', 10, 1 );
function order_received_empty_cart_action( $order_id ){
    WC()->cart->empty_cart();
}

remove_action( 'um_submit_form_errors_hook_login', 'um_submit_form_errors_hook_login' );
function um_submit_form_errors_hook_login_custom( $submitted_data ) {
    $user_password = $submitted_data['user_password'];

    if ( isset( $submitted_data['username'] ) && '' === $submitted_data['username'] ) {
        UM()->form()->add_error( 'username', __( 'Please enter your phone number', 'ultimate-member' ) );
    }

    if ( isset( $submitted_data['user_login'] ) && '' === $submitted_data['user_login'] ) {
        UM()->form()->add_error( 'user_login', __( 'Please enter your username', 'ultimate-member' ) );
    }

    if ( isset( $submitted_data['user_email'] ) && ( '' === $submitted_data['user_email'] || ! is_email( $submitted_data['user_email'] ) ) ) {
        UM()->form()->add_error( 'user_email', __( 'Please enter your email', 'ultimate-member' ) );
    }

    if ( isset( $submitted_data['username'] ) ) {
        $authenticate = $submitted_data['username'];
        $field = 'username';
        if ( is_email( $submitted_data['username'] ) ) {
            $data = get_user_by('email', $submitted_data['username'] );
            $user_name = isset( $data->user_login ) ? $data->user_login : '';
        } else {
            $user_name  = $submitted_data['username'];
        }
    } elseif ( isset( $submitted_data['user_email'] ) ) {
        $authenticate = $submitted_data['user_email'];
        $field = 'user_email';
        $data = get_user_by('email', $submitted_data['user_email'] );
        $user_name = isset( $data->user_login ) ? $data->user_login : '';
    } else {
        $field = 'user_login';
        $user_name = $submitted_data['user_login'];
        $authenticate = $submitted_data['user_login'];
    }

    if ( $submitted_data['user_password'] == '' ) {
        UM()->form()->add_error( 'user_password', __( 'Please enter your password', 'ultimate-member' ) );
    }

    $user = get_user_by( 'login', $user_name );
    if ( $user && wp_check_password( $submitted_data['user_password'], $user->data->user_pass, $user->ID ) ) {
        UM()->login()->auth_id = username_exists( $user_name );
    } else {
        UM()->form()->add_error( 'user_password', __( 'Password is incorrect. Please try again.', 'ultimate-member' ) );
    }

    // Integration with 3rd-party login handlers e.g. 3rd-party reCAPTCHA etc.
    $third_party_codes = apply_filters( 'um_custom_authenticate_error_codes', array() );

    // @since 4.18 replacement for 'wp_login_failed' action hook
    // see WP function wp_authenticate()
    $ignore_codes = array( 'empty_username', 'empty_password' );

    $user = apply_filters( 'authenticate', null, $authenticate, $submitted_data['user_password'] );
    if ( is_wp_error( $user ) && ! in_array( $user->get_error_code(), $ignore_codes ) ) {
        if ( ! empty( $third_party_codes ) && in_array( $user->get_error_code(), $third_party_codes ) ) {
            UM()->form()->add_error( $user->get_error_code(), $user->get_error_message() );
        } else {
            UM()->form()->add_error( 'user_password', __( 'Password is incorrect. Please try again.', 'ultimate-member' ) );
        }
    }

    $user = apply_filters( 'wp_authenticate_user', $user, $submitted_data['user_password'] );
    if ( is_wp_error( $user ) && ! in_array( $user->get_error_code(), $ignore_codes ) ) {
        if ( ! empty( $third_party_codes ) && in_array( $user->get_error_code(), $third_party_codes ) ) {
            UM()->form()->add_error( $user->get_error_code(), $user->get_error_message() );
        } else {
            UM()->form()->add_error( 'user_password', __( 'Password is incorrect. Please try again.', 'ultimate-member' ) );
        }
    }

    // if there is an error notify wp
    if ( UM()->form()->has_error( $field ) || UM()->form()->has_error( $user_password ) || UM()->form()->count_errors() > 0 ) {
        do_action( 'wp_login_failed', $user_name, UM()->form()->get_wp_error() );
    }
}
add_action( 'um_submit_form_errors_hook_login', 'um_submit_form_errors_hook_login_custom' );


  // Hook into the admin_enqueue_scripts action to modify the title


add_action( 'woocommerce_payment_complete', 'custom_woocommerce_payment_complete' );
function custom_woocommerce_payment_complete( $order_id ) {
    $order = wc_get_order( $order_id );
    
    if ( $order && $order->has_status( 'processing' ) ) {
        $order->update_status( 'completed' );
    }
}

function add_agent_role() {
    add_role(
        'agent', // Role ID
        'Agent', // Display Name
        array(
            'read'                 => true,
            'edit_posts'           => true,
            'edit_products'        => true,
            'publish_products'     => true,
            'manage_woocommerce'   => true, // Set to false to restrict certain capabilities
            'view_woocommerce_reports' => true,
            // Add other capabilities as needed
        )
    );
}
add_action('init', 'add_agent_role');

function add_staff_role() {
    add_role(
        'staffnew', // Role ID
        'staffnew', // Display Name
        array(
            'read'                 => true,
            'edit_posts'           => true,
            'edit_products'        => true,
            'publish_products'     => true,
            'manage_woocommerce'   => true, // Set to false to restrict certain capabilities
            'view_woocommerce_reports' => true,
            // Add other capabilities as needed
        )
    );
}
add_action('init', 'add_staff_role');


function custom_hide_menus_based_on_role() {
    // Get the current user object
    $current_user = wp_get_current_user();
    $user_roles = $current_user->roles;

    // Define which roles should see which menus/submenus
    $menu_modifications = array(
        'staffnew' => array(
            'Analytics', // Hide the "Appearance" menu for editors
            'wpcf7', // Hide the "Appearance" menu for editors
            'wc-admin&path=/marketing', // Hide the "Appearance" menu for editors
            'edit-comments.php', // Hide the "Appearance" menu for editors
            'submenu_page_menu_editor',
            'ultimatemember',
            'glsr-settings',
            'menu_editor',
            array('options-general.php', 'glsr-settings'), // Hide "Site Reviews" settings submenu under "Settings"
          
            // Add more menu items to hide as needed
        ),
        'agent' => array(
            'Analytics', // Hide the "Appearance" menu for editors
            'wpcf7', // Hide the "Appearance" menu for editors
            'wc-admin&path=/marketing', // Hide the "Appearance" menu for editors
            'edit-comments.php', // Hide the "Appearance" menu for editors
            'submenu_page_menu_editor',
            'ultimatemember',
            'glsr-settings',//site reviews
            'menu_editor',
            array('options-general.php', 'glsr-settings'), // Hide "Site Reviews" settings submenu under "Settings"
          
            // Add more menu items to hide as needed
        ),
        // Add more role => menu modifications as needed
    );

  
    // Loop through each modification and apply it
    foreach ($menu_modifications as $role => $menus_to_hide) {
        if (in_array($role, $user_roles)) {
            foreach ($menus_to_hide as $menu_slug) {
                if (is_array($menu_slug)) {
                    // Handle submenu items
                    remove_submenu_page($menu_slug[0], $menu_slug[1]);
                } else {
                    // Handle top-level menu items
                    remove_menu_page($menu_slug);
                }
            }
        }
    }
}
add_action('admin_menu', 'custom_hide_menus_based_on_role');

function custom_role_css()
{

    $current_user = wp_get_current_user();
    $user_roles = $current_user->roles;
    
    if (in_array("staffnew", $user_roles)) {
        wp_enqueue_style( 'staff_css', get_stylesheet_directory_uri() . '/assets/css/staff.css', false, '1.0.0' );
    } elseif (in_array("agent", $user_roles)) {
        wp_enqueue_style( 'agent_css', get_stylesheet_directory_uri() . '/assets/css/staff.css', false, '1.0.0' );
    }elseif (in_array("admin", $user_roles)) {
        wp_enqueue_style( 'admin_css', get_stylesheet_directory_uri() . '/assets/css/admin.css', false, '1.0.0' );
    }
    wp_enqueue_script( 'dashboard_js', get_stylesheet_directory_uri(). '/assets/js/dashboard.js', array( 'jquery' ), '1.0.0', true );

}

add_action('admin_enqueue_scripts', 'custom_role_css');

function add_custom_capabilities_to_staff() {
    // Get the role object
    $role = get_role('staffs');

    if ($role) {
        $role->add_cap('edit_shop_orders');
        $role->add_cap('publish_shop_orders');
        $role->add_cap('read_shop_orders');
        $role->add_cap('create_shop_orders'); // Custom capability to create orders
    }
}
// Run the function on theme setup
add_action('after_setup_theme', 'add_custom_capabilities_to_staff');

function custom_checkout_fields($fields) {
    // Check if the current user is a 'staff' or 'agency'
    if (current_user_can('staff') || current_user_can('agency')) {
        // Remove billing address fields
        unset($fields['billing']['billing_address_1']);
        unset($fields['billing']['billing_address_2']);
        unset($fields['billing']['billing_city']);
        unset($fields['billing']['billing_postcode']);
        unset($fields['billing']['billing_country']);
        unset($fields['billing']['billing_state']);

        // Remove shipping address fields
        unset($fields['shipping']['shipping_address_1']);
        unset($fields['shipping']['shipping_address_2']);
        unset($fields['shipping']['shipping_city']);
        unset($fields['shipping']['shipping_postcode']);
        unset($fields['shipping']['shipping_country']);
        unset($fields['shipping']['shipping_state']);
    }

    return $fields;
}
add_filter('woocommerce_checkout_fields', 'custom_checkout_fields');
function hide_ovabrw_childrens_field() {
    // Only enqueue on the specific admin page
    $screen = get_current_screen();
    if ( $screen->id === 'product_page_ovabrw-create-order' ) {
        ?>
        <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function() {
            var childrenInput = document.getElementById('ovabrw_childrens');
            if (childrenInput) {
                childrenInput.value = 0; // Ensure the value meets the constraints
                childrenInput.style.display = 'none'; // Hide the field
                childrenInput.disabled = true; // Disable the field to remove focusability
            }
        });
        </script>
        <?php
    }
}
add_action('admin_footer', 'hide_ovabrw_childrens_field');

function custom_remove_woocommerce_product_columns( $columns ) {
     unset( $columns['sku'] );         // Remove SKU column
     unset( $columns['is_in_stock'] ); // Remove Stock column
     unset( $columns['product_tag'] ); // Remove Tag column
     unset( $columns['featured'] );    // Remove Featured column
     unset( $columns['date'] );        // Remove Date column
     unset( $columns['stats'] );       // Remove Stats column
     unset( $columns['aioseo-details'] ); // Remove AIOSEO Details column
     return $columns;
 }
 add_filter( 'manage_edit-product_columns', 'custom_remove_woocommerce_product_columns' );
 add_filter( 'manage_edit-product_columns', 'custom_remove_woocommerce_product_columns' );
function add_custom_dashboard_widget() {
    wp_add_dashboard_widget(
        'custom_dashboard_widget',     // Widget slug.
        'Latest WooCommerce Orders',   // Title.
        'custom_dashboard_widget_content' // Display function.
    ); 
}
add_action('wp_dashboard_setup', 'add_custom_dashboard_widget' );

function custom_dashboard_widget_content() {
    // Query the latest 5 WooCommerce orders.
    $args = array(
        'post_type' => 'shop_order',
        'posts_per_page' => 5,
        'post_status' => 'wc-completed' // Only completed orders, adjust as necessary.
    );

    $orders = get_posts($args);

    if ( ! empty( $orders ) ) {
        echo '<ul>';
        foreach ( $orders as $order_post ) {
            $order = wc_get_order( $order_post->ID );
            echo '<li>';
            echo '<strong>Order #:</strong> ' . $order->get_order_number() . '<br>';
            echo '<strong>Date:</strong> ' . $order->get_date_created()->date('Y-m-d H:i:s') . '<br>';
            echo '<strong>Total:</strong> ' . $order->get_formatted_order_total() . '<br>';
            echo '<strong>Status:</strong> ' . wc_get_order_status_name( $order->get_status() );
            echo '</li><br>';
        }
        echo '</ul>';
    } else {
        echo 'No recent orders found.';
    }
}


if (class_exists('WooCommerce')) {
    // Add the price column to the product list in the admin
    add_filter('manage_edit-product_columns', 'add_price_column', 10, 1);
    function add_price_column($columns) {
        $columns['price'] = __('Price Starting From', 'woocommerce');
        return $columns;
    }

    // Display the price column content in the product list in the admin
    add_action('manage_product_posts_custom_column', 'display_price_column_content', 10, 2);
    function display_price_column_content($column, $postid) {
       
        if ($column === 'price') {
            
            $product = wc_get_product($postid);
            if ($product) {
                $ovabrw_petime_price = get_post_meta($postid, 'ovabrw_petime_price', true);

                $count = count($ovabrw_petime_price);

                if ($count == 1) {
                    // If there's only one element, echo that element
                    echo $ovabrw_petime_price[0];
                }/* elseif ($count >= 2) {
                    if($ovabrw_petime_price[1]){
                    // If there are at least two elements, echo the first and second elements
                    echo $ovabrw_petime_price[0] . '-' . $ovabrw_petime_price[1];
                    }else{
                        echo $ovabrw_petime_price[0];
                    }
                } */
             }
        }


        if ($column === 'taxonomy-boat') {
           // echo 'hii';
            $product = wc_get_product($postid);
            if ($product) {
                $boat_term_id_requested = get_post_meta( $postid, 'boat_term_id', true );
               //echo 'bid'.$boat_term_id_requested;
             }
        }
    }
    
}

function enqueue_custom_admin_script() {
    // Get the current screen
    $current_screen = get_current_screen();

    // Check if we are on the profile page
    if ($current_screen && $current_screen->id === 'profile') {
        // Enqueue the script
        echo '<script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
            let firstTable = document.querySelector("table.form-table");
            
            // Hide the first table
            if (firstTable) {
                firstTable.style.display = "none";
            }
        });
    </script>';
        // Inline script
      
    }
}

add_action('admin_enqueue_scripts', 'enqueue_custom_admin_script');



function enqueue_custom_admin_scripts($hook_suffix) {  
    // Only load the script on the specific WooCommerce admin page
    if ($hook_suffix === 'product_page_ovabrw-manage-order') {

        wp_enqueue_script('custom_script',  get_stylesheet_directory_uri() . '/assets/js/custom_script.js', array('jquery'), null, true);
    }
}
add_action('admin_enqueue_scripts', 'enqueue_custom_admin_scripts');



function remove_product_title_links_js_for_non_admin() {
    // Check if the current user is an administrator
    if (!current_user_can('administrator')) {
        ?>
        <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function() {
            // Select all product title links in the product list table
            const productTitleLinks = document.querySelectorAll('.column-name a.row-title');

            // Iterate over each link and remove the href attribute
            productTitleLinks.forEach(function(link) {
                link.removeAttribute('href');
            });

            console.log('All product title links have been modified to remove href attributes for non-admin users.');
        });
        </script>
        <?php
    }
}
add_action('admin_footer', 'remove_product_title_links_js_for_non_admin');

function modify_view_links_js_based_on_user_role() {
    if (!current_user_can('administrator')) {
         // JavaScript for admin users to open 'View' links in a new tab
       ?>
        <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function() {
            // Select all 'View' links in the product list table
            const viewLinks = document.querySelectorAll('.column-name a[aria-label^="View"]');

            // Iterate over each link and set the target attribute to open in a new tab
            viewLinks.forEach(function(link) {
                link.setAttribute('target', '_blank');
            });

            console.log('Product "View" links will open in a new tab for admin users.');
        });
        </script>
        <?php
    }
}
add_action('admin_footer', 'modify_view_links_js_based_on_user_role');



function affiliate_application_approved_callback($affiliate_id) {
    global $wpdb;

    // Get the user ID from the affiliate ID
    $user_id = $wpdb->get_var($wpdb->prepare(
        "SELECT userId FROM bt_wpam_affiliates WHERE affiliateId = %d",
        $affiliate_id
    ));
    
    if ($user_id) {
        // Get the phone number from the bt_wpam_affiliates table
        $phone_number = $wpdb->get_var($wpdb->prepare(
            "SELECT phoneNumber FROM bt_wpam_affiliates WHERE affiliateId = %d",
            $affiliate_id
        ));
        
        if ($phone_number) {
            // Update the phone number field in the WP user profile
            update_user_meta($user_id, 'mobile_number', $phone_number); // Adjust meta key if necessary
        }

        $meta_key = 'bt_capabilities';
        $capabilities = get_user_meta($user_id, $meta_key, true);

        // If capabilities is empty or not an array, initialize it as an array
        if (empty($capabilities) || !is_array($capabilities)) {
            $capabilities = array();
        }

        // Add the "affiliate" role if not already present
        if (!isset($capabilities['affiliate'])) {
            $capabilities['affiliate'] = true;

            // Serialize the updated capabilities
            //$updated_capabilities = serialize($capabilities);

            // Update the user meta with the new capabilities
            update_user_meta($user_id, $meta_key, $capabilities);
        }
    }
}
add_action('wpam_affiliate_application_approved', 'affiliate_application_approved_callback');

function rename_first_name_to_full_name() {
    global $wpdb;

    // Check if the entry already renamed to avoid duplicate runs
    $entry = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}wpam_affiliates_fields WHERE name = 'First Name'");

    if ($entry > 0) {
        // Run the update query
        $wpdb->query("
            UPDATE {$wpdb->prefix}wpam_affiliates_fields
            SET name = 'Full Name'
            WHERE name = 'First Name'
        ");
    }
}
// Hook into WordPress init action to ensure it runs only once
add_action('init', 'rename_first_name_to_full_name');

function update_multiple_wpam_message_contents() {
    global $wpdb;

    // Define the new content for each condition
    $updates = array(
        'affiliate_application_submitted' => 'Your application has been submitted and sent to Admin for approval. <br /><br />Thank you!<br />',
        'affiliate_application_approved' => 'Congratulations, the administrator has <strong>approved</strong> your application. You have one more step to complete. Please review and agree to the terms of your agreement.<br /><br />',
        'affiliate_application_approved_email' => 'Your affiliate account for {blogname} has been approved!. Please logout and re-login with your registered mobile number , then click on the Affiliate Home link on the top menu and complete the steps given to activate your account. Login URL: {affloginurl}',
        'affiliate_application_declined' => 'Sorry, your application was declined.',
        'affiliate_application_declined_email' => 'Sorry, your application was declined.',
        'aff_app_submitted_auto_approved' => 'Thank you. Your registration is now complete. You can log into the Affiliate Home and begin promoting.',
        'admin_affiliate_commission_notification_email' => 'An affiliate just earned a commission by sending a referral to the site. Please log into your affiliate dashboard to view the details.',
        // Add more conditions and their new contents here
    );

    // Loop through each condition and update the content
    foreach ($updates as $name => $new_content) {
        $updated = $wpdb->update(
            $wpdb->prefix . 'wpam_messages', // Table name
            array('content' => $new_content), // Data to update
            array('name' => $name), // Where condition
            array('%s'), // Data format
            array('%s') // Where format
        );

        if ($updated === false) {
            echo 'An error occurred while updating the content for name: ' . $name;
        }
    }
}

// Hook the function to an action to run it once
add_action('init', 'update_multiple_wpam_message_contents');


function rename_phone_number_in_affiliates_fields() {
    global $wpdb;

    // Update query to rename "Phone Number" to "Phone Number (with Country Code)"
    $updated = $wpdb->update(
        $wpdb->prefix . 'wpam_affiliates_fields', // Table name
        array('name' => 'Phone Number (with Country Code)'), // Data to update
        array('name' => 'Phone Number'), // Where condition
        array('%s'), // Data format
        array('%s') // Where format
    );

    if ($updated === false) {
        echo 'An error occurred while updating the name.';
    } else {
    }
}

// Hook the function to an action to run it once
function track_affiliate_commission($order_id) {
    if (isset($_COOKIE['wpam_id'])) {
        $affiliate_id = intval($_COOKIE['wpam_id']);
        $order = wc_get_order($order_id);
        $order_total = $order->get_total();

        // Retrieve the bounty amount (commission rate) for this affiliate
        global $wpdb;
        $bountyamount = $wpdb->get_var($wpdb->prepare(
            "SELECT bountyAmount FROM " . $wpdb->prefix . "wpam_affiliates WHERE affiliateId = %d",
            $affiliate_id
        ));

        $bountytype = $wpdb->get_var($wpdb->prepare(
            "SELECT bountyType FROM " . $wpdb->prefix . "wpam_affiliates WHERE affiliateId = %d",
            $affiliate_id
        ));

        $bountyamount = floatval($bountyamount);

        if ($bountytype === "percent") {
            // Calculate commission
            $commission = $order_total * ($bountyamount/100); // Affiliate commission rate if percent of sales
        } else {
            $commission = $bountyamount; // Affiliate commission rate if fixed commission per sale
        }
        

        // Retrieve transaction_id and billing_email from bt_wc_orders
        $order_data = $wpdb->get_row($wpdb->prepare(
            "SELECT transaction_id, billing_email, date_created_gmt FROM " . $wpdb->prefix . "wc_orders WHERE id = %d",
            $order_id
        ), ARRAY_A);

        if ($order_data) {
            $transaction_id = $order_data['transaction_id'];
            $billing_email = $order_data['billing_email'];
            $date_created = $order_data['date_created_gmt'];

            // Record commission in bt_wpam_transactions
            $wpdb->insert(
                $wpdb->prefix . 'wpam_transactions',
                array(
                    'affiliateId' => $affiliate_id,
                    'referenceId' => $transaction_id,
                    'transactionId' => $order_id,
                    'amount' => $commission,
                    'email' => $billing_email,
                    'dateCreated' => $date_created,
                    'status' => 'confirmed',
                    'dateModified' => current_time('mysql')
                ),
                array(
                    '%d',
                    '%s',
                    '%d',
                    '%f',
                    '%s',
                    '%s',
                    '%s'
                )
            );
        }
    }
}
add_action('woocommerce_order_status_completed', 'track_affiliate_commission');


// Ensure this is added to the end of functions.php, before the closing PHP tag if there is one

// Function to add Google Analytics script
function add_google_analytics() {
    ?>

    <script async src="https://www.googletagmanager.com/gtag/js?id=G-QLSTN4PPZP"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-QLSTN4PPZP');
    </script>
    <?php
}
// Hook the function to wp_head action
add_action('wp_head', 'add_google_analytics');



function custom_search_text( $translated_text, $text, $domain ) {
    if ( is_woocommerce() ) {
        if ( $text === 'Search products&hellip;' ) {
            $translated_text = __( 'Search charters&hellip;', 'woocommerce' );
        }
        if ( $text === 'Search for products' ) {
            $translated_text = __( 'Search for charters', 'woocommerce' );
        }
    }
    return $translated_text;
}
add_filter( 'gettext', 'custom_search_text', 20, 3 );



function custom_site_reviews_no_reviews_message( $message ) {
    return 'No reviews yet. Be the first to share your experience by writing a review!';
}
add_filter( 'glsr_no_reviews_text', 'custom_site_reviews_no_reviews_message' );
function check_for_reviews() {
    global $post;

    // Assuming 'glsr_reviews' is the custom post type for reviews
    $args = array(
        'post_type' => 'glsr_reviews',
        'post_status' => 'publish',
        'meta_query' => array(
            array(
                'key' => 'post_id', // or whatever key you use to link reviews to posts
                'value' => $post->ID,
            )
        )
    );

    $reviews = new WP_Query($args);

    if ($reviews->have_posts()) {
        return true;
    } else {
        return false;
    }
}

// Add a class to the body if there are no reviews
function custom_body_class( $classes ) {
    if ( !check_for_reviews() ) {
        $classes[] = 'no-reviews';
    }
    return $classes;
}
add_filter( 'body_class', 'custom_body_class' );


function custom_modify_jetpack_status_title() {
    global $menu;

    // Loop through the admin menu to find the Jetpack Status menu item
    foreach ( $menu as $key => $item ) {
        if ( $item[0] === 'Jetpack Status' ) {
            // Modify the title to 'Website Traffic Overview'
            $menu[$key][0] = 'Website Traffic Overview';
            break; // Exit the loop once modified
        }
    }
}
add_action( 'admin_menu', 'custom_modify_jetpack_status_title', 999 );
function custom_modify_captcha_label( $fields ) {
    // Modify the CAPTCHA field label
    $fields['captcha']['label'] = 'Prove you are human:';

    return $fields;
}
add_filter( 'comment_form_default_fields', 'custom_modify_captcha_label' );


// Function to handle AJAX request and return user data
function get_user_data() {
    if (is_user_logged_in()) {
        $user_id = get_current_user_id();
        
        // Get first name and phone number
        $first_name = get_user_meta($user_id, 'first_name', true);
        $phone = get_user_meta($user_id, 'mobile_number', true); // Adjust meta key as needed

        wp_send_json_success(array(
            'first_name' => $first_name,
            'phone' => $phone
        ));
    } else {
        wp_send_json_error('User not logged in');
    }
}
add_action('wp_ajax_get_user_data', 'get_user_data');
add_action('wp_ajax_nopriv_get_user_data', 'get_user_data');

function enqueue_autofill_script() {
    wp_enqueue_script('autofill-affiliate-registration', get_stylesheet_directory_uri() . '/assets/js/autofill-affiliate-registration.js', array('jquery'), null, true);

    wp_localize_script('autofill-affiliate-registration', 'ajaxurl', admin_url('admin-ajax.php'));
}
add_action('wp_enqueue_scripts', 'enqueue_autofill_script');


function add_loader_to_admin_page() {
    $screen = get_current_screen();
    if ( $screen->id == 'product_page_ovabrw-create-order' ) {
        echo '<div class="loader" id="loader" style="display: none;">Loading...</div>';
    }
}
add_action('admin_footer', 'add_loader_to_admin_page');




function enqueue_custom_admin_script_s() {
    ?>
    <script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
        // Check if we're on the correct page by verifying the URL
        if (window.location.href.includes('edit.php?post_type=product&page=ovabrw-create-order')) {
            const container = document.querySelector('.wrap .ovabrw-wrap .ovabrw-order .item .ovabrw-meta');
            const validateButtons = document.querySelectorAll('.validatebtn'); // Select elements by class
            const errorMessage = document.querySelector('.ovabrw-error');
            const dateInput = document.getElementById('ovabrw-pickup-date'); // Date input field
            const productDropdown = document.getElementById('ovabrw-name-product');
            const packageDropdown = document.getElementById('ovabrw-package');
            const loader = document.getElementById('loader'); // Get the loader element

                // If jQuery is available
    if (typeof jQuery !== 'undefined') {
        jQuery(document).ready(function($) {
            // Create the checkbox element
            const checkbox = $('<input>', {
                type: 'checkbox',
                id: 'date-checkbox',
                name: 'date-checkbox',
                style: 'margin-left: 10px;'
                
            });

            // Create the label for the checkbox
            const checkboxLabel = $('<label>', {
                for: 'date-checkbox',
                text: 'Confirm Date',
                css: {
                'margin-left': '5px',
                'vertical-align': 'middle'
            }
            });

                        // Find the div with class "ovabrw-row"
                        const targetDiv = $('.product_page_ovabrw-create-order .ovabrw-row');

// Append the checkbox and label to the target div
if (targetDiv.length) {
   // targetDiv.append(checkbox, checkboxLabel);
    targetDiv.find('a.insert_wrap_item').after(checkbox, checkboxLabel);
}

            

            // Insert the checkbox and label after the date input field
            //$(dateInput).after(checkbox, checkboxLabel);

        });

    }
//alert(packageDropdown);
            if (container) {
                container.classList.add('hide-elements');
                container.style.display = 'none';
            }
var flag =0;
            // Function to handle product dropdown change
            function handleProductDropdownChange() {
              
                if (loader) {
                    loader.style.display = 'block'; // Show the loader
                }

                const containers = document.querySelector('.wrap .ovabrw-wrap .ovabrw-order .item .ovabrw-meta');
                if (containers) {

                    setTimeout(function() {
                        containers.classList.remove('hide-elements'); // Remove the class to show elements again
                        containers.style.display = 'block'; // Ensure the container is displayed again

                        if (loader) {
                            loader.style.display = 'none'; // Hide the loader
                        }
                    }, 9000); // Delay in milliseconds (9000ms = 9 seconds)
                }
            }
            
               // Event listener for product dropdown change
               if (productDropdown) {
                productDropdown.addEventListener('change', handleProductDropdownChange);
            }
            
            /*
            function handlepackageDropdownChange() {
                alert('hi');
                var selectElement = document.getElementById("ovabrw-package");
            var selectedValue = selectElement.value;
           // document.getElementById("selectedValue").innerText =  selectedValue;
           
alert(selectedValue);
                if (selectedValue == '0') {
                    alert('Selected date is already blocked.'); // Debug alert for blocking action
                    event.preventDefault();
                }

             
          }

         
            if (packageDropdown) {
                alert('package');
                packageDropdown.addEventListener('change', handlepackageDropdownChange);
            }
            
            // Function to handle validate button click
            function handleValidateButtonClick(event) {
                //alert('check');
                // Check for the error message and block the action if it's displayed

                var selectElement = document.getElementById("ovabrw-package");
            var selectedValue = selectElement.value;
           // document.getElementById("selectedValue").innerText =  selectedValue;
           
alert(selectedValue);
                if (selectedValue == '0') {
                    alert('Selected date is already blocked.'); // Debug alert for blocking action
                    event.preventDefault();
                }else{
                    flag=3;
                }
            }
if(flag==3){
            // Add click event listener to all validate buttons
            validateButtons.forEach(button => {
               
               button.addEventListener('click', handleValidateButtonClick);
           });
        }*/
        }
    });

    </script>
    <?php
}
add_action('admin_enqueue_scripts', 'enqueue_custom_admin_script_s');

function custom_admin_bar_script() {
    ?>
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
            var element = document.getElementById('wp-admin-bar-wp-logo');
            if (element) {
                element.classList.add('menupop');
            }
        });
    </script>
    <?php
}
add_action('admin_head', 'custom_admin_bar_script');


// Change the URL of the admin bar logo
function custom_admin_logo_url($wp_admin_bar) {
    // Remove the existing 'wp-logo' node
    $wp_admin_bar->remove_node('wp-logo');

    // Add a new 'wp-logo' node with a custom URL
    $wp_admin_bar->add_node(array(
        'id' => 'wp-logo',
        'title' => '<span class="ab-icon"></span>',
        'href' => 'https://a1boat.test4u.in/', // Replace with your desired URL
        'meta' => array(
            'title' => __('A1Boat Charters Ltd'),
        ),
    ));
}
add_action('admin_bar_menu', 'custom_admin_logo_url', 11);

// Optionally, change the logo image itself
function custom_admin_logo_css() {
    echo '
    <style type="text/css">
        #wpadminbar #wp-admin-bar-wp-logo>.ab-item .ab-icon:before {
            content: "";
            background-image: url(https://a1boat.test4u.in/wp-content/uploads/2022/04/a1-boat-charters-logo-home.png); /* Replace with your logo URL */
            background-size: contain;
            background-repeat: no-repeat;
            width: 20px; /* Adjust the width */
            height: 20px; /* Adjust the height */
            display: inline-block;
        }
    </style>
    ';
}
add_action('admin_head', 'custom_admin_logo_css');
