<?php
/**
 * The template for displaying weekdays content within single
 *
 * This template can be overridden by copying it to yourtheme/ovabrw-templates/single/table-price/weekdays.php
 *
 */

if ( ! defined( 'ABSPATH' ) ) exit();

	if( isset( $args['product_id'] ) && $args['product_id'] ){
		$pid = $args['product_id'];
	}else{
		$pid = get_the_id();
	}

	$daily = ovabrw_p_weekdays( $pid );

	if( !empty( $daily ) ){
?>

	<div class="price_table">
        <label><?php esc_html_e( 'Weekdays', 'ova-brw' ); ?></label>
        
		<table>
			<thead>
				<tr>
					<th><?php esc_html_e( 'Mon', 'ova-brw' ); ?></th>
					<th><?php esc_html_e( 'Tue', 'ova-brw' ); ?></th>
					<th><?php esc_html_e( 'Wed', 'ova-brw' ); ?></th>
					<th><?php esc_html_e( 'Thu', 'ova-brw' ); ?></th>
					<th><?php esc_html_e( 'Fri', 'ova-brw' ); ?></th>
					<th><?php esc_html_e( 'Sat', 'ova-brw' ); ?></th>
					<th><?php esc_html_e( 'Sun', 'ova-brw' ); ?></th>
				</tr>
			</thead>

			<tbody>

				<tr class="odd">
					
					<?php foreach ($daily as $key => $value) { ?>

						<?php
							switch ($key) {
								case 'monday':
									$day = esc_html__( 'Mon', 'ova-brw' );
									break;
								case 'tuesday':
									$day = esc_html__( 'Tue', 'ova-brw' );
									break;
								case 'wednesday':
									$day = esc_html__( 'Wed', 'ova-brw' );
									break;
								case 'thursday':
									$day = esc_html__( 'Thu', 'ova-brw' );
									break;
								case 'friday':
									$day = esc_html__( 'Fri', 'ova-brw' );
									break;
								case 'saturday':
									$day = esc_html__( 'Sat', 'ova-brw' );
									break;	
								case 'sunday':
									$day = esc_html__( 'Sun', 'ova-brw' );
									break;		
								
								default:
									$day = '';
									break;
							}
						?>
					
					    <td data-title="<?php echo esc_attr( $day ); ?>">
					    	<?php echo wc_price( $value ); ?>
					    </td>

					<?php } ?>
				</tr>
			</tbody>

		</table>
	</div>

<?php } ?>

