<?php if( ! defined( 'ABSPATH' ) ) exit();

extract( $args );

// Get first day in week
$first_day 		= get_option( 'ova_brw_calendar_first_day', '0' );
$date_format 	= ovabrw_get_date_format();
$time_format    = ovabrw_get_time_format_php();
$placeholder_date_format = ovabrw_get_placeholder_date_format( $date_format );
$hour_default 	= ovabrw_get_setting( get_option( 'ova_brw_booking_form_default_hour', '07:00' ) );
$time_step 		= ovabrw_get_setting( get_option( 'ova_brw_booking_form_step_time', '30' ) );

$show_time      = $args['show_time'] === "yes" ? "true" : "false";

$data_get = $_GET;
$ovabrw_pickup_date 	= isset( $data_get['ovabrw_pickup_date'] ) ? sanitize_text_field( $data_get['ovabrw_pickup_date'] ) : '';
$ovabrw_pickoff_date    = '';
$ovabrw_package         = isset( $data_get['ovabrw_package'] ) ? sanitize_text_field( $data_get['ovabrw_package'] ) : 0;

if ( isset( $data_get['ovabrw_pickoff_date'] ) ) {
	$ovabrw_pickoff_date 	= sanitize_text_field( $data_get['ovabrw_pickoff_date'] );
} elseif( $ovabrw_package ) {
	if ( is_numeric( $data_get['ovabrw_package'] ) ) {
	    $ovabrw_pickoff_date = date($date_format.' '.$time_format, strtotime( $ovabrw_pickup_date ) + $ovabrw_package );
    }
} else {
	$ovabrw_pickoff_date = '';
}

$check_in_label  = $args['check_in_label'];
$check_out_label = $args['check_out_label'];
$guests_label 	 = $args['guests_label'];
$button_label 	 = $args['button_label'];

$package_placeholder     = $args['package_placeholder'];
$guests_placeholder      = $args['guests_placeholder']; 

// Adults
$adults_label 	= $args['adults_label'];
$default_adults = isset( $data_get['ovabrw_adults'] ) ? intval( $data_get['ovabrw_adults'] ) : intval( $args['default_adults'] );
$max_adults 	= $args['max_adults'];
$min_adults 	= $args['min_adults'];

// Childrens
$childrens_label    = $args['childrens_label'];
$default_childrens 	= isset( $data_get['ovabrw_childrens'] ) ? intval( $data_get['ovabrw_childrens'] ) : intval( $args['default_childrens'] );
$max_childrens 		= $args['max_childrens'];
$min_childrens 		= $args['min_childrens'];

$persons = intval( $default_adults ) + intval( $default_childrens );

$data = array(
	'orderby' 	=> $orderby,
	'order' 	=> $order,
	'posts_per_page' => $posts_per_page,
);

$products = ovabrw_search_products( $data );

?>

<div class="ova-search-ajax">
	<!-- Search Map -->
	<div class="wrap-search-ajax">
		<form class="form-search-map" autocomplete="off">
			<div class="wrap-search-fields">
				<?php
					// Fields
					foreach ( $args as $key => $value) {
						if ( strpos( $key,'field_' ) !== false ) {
							switch ( $args[$key] ) {
								case 'start_date':
									?>
									<div class="search-field search-ajax-start-date">
										<i aria-hidden="true" class="icomoon icomoon-calendar-alt"></i>
										<div class="ovabrw-input">
											<span class="label"><?php echo esc_html( $check_in_label ); ?></span>
											<input 
												type="text" 
												name="ovabrw_pickup_date" 
												value="<?php echo esc_attr( $ovabrw_pickup_date ); ?>" 
												onkeydown="return false" 
												class="ovabrw_datetimepicker ovabrw_start_date" 
												placeholder="<?php echo esc_attr( $placeholder_date_format ); ?>" 
												autocomplete="off" 
												data-hour_default="<?php echo esc_attr( $hour_default ); ?>" 
												data-time_step="<?php echo esc_attr( $time_step ); ?>" 
												data-dateformat="<?php echo esc_attr( $date_format ); ?>"
												timepicker="<?php echo esc_attr( $show_time ); ?>" 
												data-firstday='<?php echo esc_attr( $first_day ); ?>' 
												/>
										</div>
									</div>
									<?php
									break;

								case 'end_date':
									?>
									<div class="search-field search-ajax-end-date">
										<i aria-hidden="true" class="icomoon icomoon-calendar-alt"></i>
										<div class="ovabrw-input">
											<span class="label"><?php echo esc_html( $check_out_label ); ?></span>
											<input 
												type="text" 
												name="ovabrw_pickoff_date" 
												value="<?php echo esc_attr( $ovabrw_pickoff_date ); ?>" 
												onkeydown="return false" 
												class="ovabrw_datetimepicker ovabrw_end_date" 
												placeholder="<?php echo esc_attr( $placeholder_date_format ); ?>" 
												autocomplete="off" 
												data-hour_default="<?php echo esc_attr( $hour_default ); ?>" 
												data-time_step="<?php echo esc_attr( $time_step ); ?>" 
												data-dateformat="<?php echo esc_attr( $date_format ); ?>" 
												timepicker="<?php echo esc_attr( $show_time ); ?>" 
												data-firstday='<?php echo esc_attr( $first_day ); ?>' 
												/>
										</div>
									</div>
									<?php
									break;
								
								case 'guests':
									?>
									<div class="search-field search-ajax-guestspicker-control">
										<i aria-hidden="true" class="icomoon icomoon-user-friends"></i>
										<div class="ovabrw-input ovabrw-guestspicker-content-wrapper">
											<span class="label"><?php echo esc_html( $guests_label ); ?></span>
											<div class="ovabrw-guestspicker">
												<div class="guestspicker">
													<span class="gueststotal"><?php echo esc_html( $persons ); ?></span>
													<span class="guestslabel"><?php echo esc_html( $guests_placeholder ); ?></span>
												</div>
											</div>
											<div class="ovabrw-guestspicker-content">
												<div class="guests-buttons">
													<label><?php echo esc_html( $adults_label ); ?></label>
													<div class="guests-button">
														<div class="guests-icon minus">
															<i class="fas fa-minus"></i>
														</div>
														<input 
															type="text" 
															id="ovabrw_adults" 
															name="ovabrw_adults" 
															class="ovabrw_adults" 
															value="<?php echo esc_attr( $default_adults ); ?>" 
															min="<?php echo esc_attr( $min_adults ); ?>" 
															max="<?php echo esc_attr( $max_adults ); ?>" />
														<div class="guests-icon plus">
															<i class="fas fa-plus"></i>
														</div>
													</div>
												</div>

												<div class="guests-buttons">
													<label><?php echo esc_html( $childrens_label ); ?></label>
													<div class="guests-button">
														<div class="guests-icon minus">
															<i class="fas fa-minus"></i>
														</div>
														<input 
															type="text" 
															id="ovabrw_childrens" 
															name="ovabrw_childrens" 
															class="ovabrw_childrens" 
															value="<?php echo esc_attr( $default_childrens ); ?>" 
															min="<?php echo esc_attr( $min_childrens ); ?>" 
															max="<?php echo esc_attr( $max_childrens ); ?>" />
														<div class="guests-icon plus">
															<i class="fas fa-plus"></i>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<?php
									break;

								case 'package':
									?>
									<div class="search-field wrap-search-package">
					                	<i aria-hidden="true" class="icomoon icomoon-layer"></i>
					                	<div class="ovabrw-input">
					                		<span class="label"><?php echo esc_html( $package_label ); ?></span>
						                	<select name="ovabrw_package" id="ovabrw_package">
						                		<option value selected="selected">
						                			<?php echo esc_html( $package_placeholder ); ?>
						                		</option>

						                		<?php foreach( $package_items as $package_item) {
						                			if( $package_item['package_type'] === "day" ) {
						                		       	$value = $package_item['package_day_value']*24*60*60;
						                		    } elseif( $package_item['package_type'] === "hour" ) {
						                                $value = $package_item['package_hour_value']*60*60;  
						                            } elseif( $package_item['package_type'] === "fixed" ) {
						                                $value = $package_item['package_start_time'].'|'.$package_item['package_end_time'];
						                            }

						                            $selected = '';
						                            if ( $ovabrw_package && $ovabrw_package == $value ) {
						                            	$selected = ' selected';
						                            }
						                		?>
							                		<option value="<?php esc_attr_e( $value ) ; ?>"<?php echo esc_html( $selected ); ?>>
							                			<?php esc_html_e( $package_item['package_name'] ); ?>
							                		</option>
						                	    <?php }?>
					                	    </select>
					                    </div>
					                </div>
									<?php
									break;
								default:
									// code...
									break;
							}
						}
					}
					// End Fields
				?>
			</div><!-- wrap_content -->
			<div class="search-ajax-btn">
				<button class="ovabrw-btn" type="submit">
					<i class="icomoon icomoon-search"></i>
					<?php printf( $button_label ); ?>
				</button>
			</div>
		</form>

		<!-- Load more -->
		<div class="wrap-load-more" style="display: none;">
			<svg class="loader" width="50" height="50">
				<circle cx="25" cy="25" r="10" />
				<circle cx="25" cy="25" r="20" />
			</svg>
		</div>
		<!-- End load more -->

		<!-- Search result -->
		<div 
			id="search-ajax-result" 
			class="search-ajax-result" 
			data-order="<?php echo esc_attr( $order ); ?>" 
			data-orderby="<?php echo esc_attr( $orderby ); ?>" 
			data-posts-per-page="<?php echo esc_attr( $posts_per_page ); ?>" 
			data-categories="<?php echo esc_attr( json_encode( $categories ) ); ?>">
		</div><!-- search_result -->
		<div class="modal-container">
			<div class="modal">
				<div class="modal-close">
					<i class="ovaicon-cancel"></i>
				</div>
				<iframe class="modal-video" allow="autoplay"></iframe>
			</div>
		</div>
	</div><!-- wrap_search -->
</div>